/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codedeploy.model.Diagnostics;

@SdkInternalApi
public class DiagnosticsMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").build();
    private static final MarshallingInfo<String> SCRIPTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scriptName").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<String> LOGTAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logTail").build();
    private static final DiagnosticsMarshaller instance = new DiagnosticsMarshaller();

    public static DiagnosticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Diagnostics diagnostics, ProtocolMarshaller protocolMarshaller) {
        if (diagnostics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)diagnostics.getErrorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.getScriptName(), SCRIPTNAME_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.getLogTail(), LOGTAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

