/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeconnections.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codeconnections.model.ProviderType;
import com.amazonaws.services.codeconnections.model.Tag;
import com.amazonaws.services.codeconnections.model.VpcConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateHostRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String providerType;
    private String providerEndpoint;
    private VpcConfiguration vpcConfiguration;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateHostRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public CreateHostRequest withProviderType(String providerType) {
        this.setProviderType(providerType);
        return this;
    }

    public CreateHostRequest withProviderType(ProviderType providerType) {
        this.providerType = providerType.toString();
        return this;
    }

    public void setProviderEndpoint(String providerEndpoint) {
        this.providerEndpoint = providerEndpoint;
    }

    public String getProviderEndpoint() {
        return this.providerEndpoint;
    }

    public CreateHostRequest withProviderEndpoint(String providerEndpoint) {
        this.setProviderEndpoint(providerEndpoint);
        return this;
    }

    public void setVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public VpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public CreateHostRequest withVpcConfiguration(VpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateHostRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateHostRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProviderType() != null) {
            sb.append("ProviderType: ").append(this.getProviderType()).append(",");
        }
        if (this.getProviderEndpoint() != null) {
            sb.append("ProviderEndpoint: ").append(this.getProviderEndpoint()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostRequest)) {
            return false;
        }
        CreateHostRequest other = (CreateHostRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProviderType() == null ^ this.getProviderType() == null) {
            return false;
        }
        if (other.getProviderType() != null && !other.getProviderType().equals(this.getProviderType())) {
            return false;
        }
        if (other.getProviderEndpoint() == null ^ this.getProviderEndpoint() == null) {
            return false;
        }
        if (other.getProviderEndpoint() != null && !other.getProviderEndpoint().equals(this.getProviderEndpoint())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProviderType() == null ? 0 : this.getProviderType().hashCode());
        hashCode = 31 * hashCode + (this.getProviderEndpoint() == null ? 0 : this.getProviderEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateHostRequest clone() {
        return (CreateHostRequest)super.clone();
    }
}

