/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeconnections.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeconnections.model.SyncBlocker;
import com.amazonaws.services.codeconnections.model.transform.SyncBlockerSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SyncBlockerSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceName;
    private String parentResourceName;
    private List<SyncBlocker> latestBlockers;

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public SyncBlockerSummary withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setParentResourceName(String parentResourceName) {
        this.parentResourceName = parentResourceName;
    }

    public String getParentResourceName() {
        return this.parentResourceName;
    }

    public SyncBlockerSummary withParentResourceName(String parentResourceName) {
        this.setParentResourceName(parentResourceName);
        return this;
    }

    public List<SyncBlocker> getLatestBlockers() {
        return this.latestBlockers;
    }

    public void setLatestBlockers(Collection<SyncBlocker> latestBlockers) {
        if (latestBlockers == null) {
            this.latestBlockers = null;
            return;
        }
        this.latestBlockers = new ArrayList<SyncBlocker>(latestBlockers);
    }

    public SyncBlockerSummary withLatestBlockers(SyncBlocker ... latestBlockers) {
        if (this.latestBlockers == null) {
            this.setLatestBlockers(new ArrayList<SyncBlocker>(latestBlockers.length));
        }
        for (SyncBlocker ele : latestBlockers) {
            this.latestBlockers.add(ele);
        }
        return this;
    }

    public SyncBlockerSummary withLatestBlockers(Collection<SyncBlocker> latestBlockers) {
        this.setLatestBlockers(latestBlockers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getParentResourceName() != null) {
            sb.append("ParentResourceName: ").append(this.getParentResourceName()).append(",");
        }
        if (this.getLatestBlockers() != null) {
            sb.append("LatestBlockers: ").append(this.getLatestBlockers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlockerSummary)) {
            return false;
        }
        SyncBlockerSummary other = (SyncBlockerSummary)obj;
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getParentResourceName() == null ^ this.getParentResourceName() == null) {
            return false;
        }
        if (other.getParentResourceName() != null && !other.getParentResourceName().equals(this.getParentResourceName())) {
            return false;
        }
        if (other.getLatestBlockers() == null ^ this.getLatestBlockers() == null) {
            return false;
        }
        return other.getLatestBlockers() == null || other.getLatestBlockers().equals(this.getLatestBlockers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getParentResourceName() == null ? 0 : this.getParentResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getLatestBlockers() == null ? 0 : this.getLatestBlockers().hashCode());
        return hashCode;
    }

    public SyncBlockerSummary clone() {
        try {
            return (SyncBlockerSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SyncBlockerSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

