/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.emitters.GeneratorPathProvider;
import com.amazonaws.codegen.internal.Freemarker;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeneratorTaskParams {
    private final Freemarker freemarker;
    private final IntermediateModel model;
    private final GeneratorPathProvider pathProvider;
    private final Log log = LogFactory.getLog(GeneratorTaskParams.class);

    public static GeneratorTaskParams create(IntermediateModel model, String outputDirectory, String sourceDirectory) {
        GeneratorPathProvider pathProvider = new GeneratorPathProvider(model, outputDirectory, sourceDirectory);
        return new GeneratorTaskParams(Freemarker.create(model), model, pathProvider);
    }

    private GeneratorTaskParams(Freemarker freemarker, IntermediateModel model, GeneratorPathProvider pathProvider) {
        this.freemarker = freemarker;
        this.model = model;
        this.pathProvider = pathProvider;
    }

    public Freemarker getFreemarker() {
        return this.freemarker;
    }

    public IntermediateModel getModel() {
        return this.model;
    }

    public GeneratorPathProvider getPathProvider() {
        return this.pathProvider;
    }

    public Log getLog() {
        return this.log;
    }
}

