/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.utils.FunctionalUtils;
import com.amazonaws.util.ImmutableMapParameter;
import freemarker.template.Template;
import java.util.List;
import java.util.stream.Collectors;

public class UnmarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final String transformClassDir;
    private final Metadata metadata;

    public UnmarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.transformClassDir = dependencies.getPathProvider().getTransformDirectory();
        this.metadata = dependencies.getModel().getMetadata();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting unmarshaller classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).map(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private GeneratorTask createTask(String javaShapeName, ShapeModel shapeModel) throws Exception {
        Template template = this.freemarker.getModelUnmarshallerTemplate();
        ShapeType shapeType = shapeModel.getShapeType();
        String shapeFqcn = shapeModel.getShapeName();
        if (TypeUtils.isReserved(shapeFqcn)) {
            shapeFqcn = shapeModel.getFullyQualifiedName();
        }
        ImmutableMapParameter dataModel = ImmutableMapParameter.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shape", (Object)shapeModel).put((Object)"shapeFqcn", (Object)shapeFqcn).put((Object)"packageName", (Object)shapeModel.getPackageName()).put((Object)"metadata", (Object)this.metadata).put((Object)"transformPackage", (Object)this.model.getTransformPackage()).put((Object)"exceptionUnmarshallerImpl", (Object)this.model.getExceptionUnmarshallerImpl()).build();
        switch (shapeType) {
            case Response: 
            case Model: {
                String unmarshallerNameSuffix = this.metadata.isJsonProtocol() ? "JsonUnmarshaller" : "StaxUnmarshaller";
                return new FreemarkerGeneratorTask(this.transformClassDir, javaShapeName + unmarshallerNameSuffix, template, dataModel);
            }
            case Exception: {
                return new FreemarkerGeneratorTask(this.transformClassDir, javaShapeName + "Unmarshaller", this.freemarker.getExceptionUnmarshallerTemplate(), dataModel);
            }
        }
        throw new IllegalStateException(shapeModel.getC2jName() + " is not supported for unmarshaller generation");
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingUnmarshaller()) {
            System.out.println("Skip generating unmarshaller class for " + shapeModel.getShapeName());
            return false;
        }
        return this.shouldGenerate(shapeModel.getShapeType());
    }

    private boolean shouldGenerate(ShapeType shapeType) {
        switch (shapeType) {
            case Response: 
            case Model: {
                return true;
            }
            case Exception: {
                if (this.model.getMetadata().getProtocol() == Protocol.API_GATEWAY) break;
                return true;
            }
        }
        return false;
    }
}

