/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final String baseDirectory;

    public SyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.baseDirectory = dependencies.getPathProvider().getBasePackageDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Sync client classes");
        return Arrays.asList(this.createClientClassTask(), this.createClientAbstractClassTask(), this.createClientBuilderTask(), this.createClientInterfaceTask());
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncClient(), this.freemarker.getSyncClientTemplate(), this.model);
    }

    private GeneratorTask createClientAbstractClassTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncAbstractClass(), this.freemarker.getSyncAbstractClassTemplate(), this.model);
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncClientBuilderClassName(), this.freemarker.getSyncClientBuilderTemplate(), this.model);
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncInterface(), this.freemarker.getSyncInterfaceTemplate(), this.model);
    }
}

