/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.emitters.GeneratorTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class GeneratorTaskExecutor {
    private static final boolean DEBUG = false;
    private final List<Future<?>> futures = new ArrayList();
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    public void submit(GeneratorTask task) {
        this.futures.add(this.executor.submit(task));
    }

    public void waitForCompletion() throws InterruptedException, ExecutionException {
        Exception firstEx = null;
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                if (firstEx != null) continue;
                firstEx = e;
            }
        }
        if (firstEx instanceof ExecutionException) {
            throw (ExecutionException)firstEx;
        }
        if (firstEx instanceof InterruptedException) {
            throw (InterruptedException)firstEx;
        }
        if (firstEx instanceof RuntimeException) {
            throw (RuntimeException)firstEx;
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

