/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.service.ErrorMap;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class PruneUnsupportedShapesProcessor
implements CodegenCustomizationProcessor {
    private static final List<Predicate<Shape>> PRUNE_CONDITIONS = Collections.singletonList(Shape::isDocument);

    @Override
    public void preprocess(ServiceModel serviceModel) {
        PruneUnsupportedShapesProcessor.pruneShapesThatMatchConditions(serviceModel);
        PruneUnsupportedShapesProcessor.doWhileShapesRemoved(serviceModel, () -> {
            PruneUnsupportedShapesProcessor.pruneCollectionShapes(serviceModel);
            PruneUnsupportedShapesProcessor.pruneShapeMembers(serviceModel);
        });
        PruneUnsupportedShapesProcessor.pruneOperationsAndErrors(serviceModel);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private static void pruneShapesThatMatchConditions(ServiceModel serviceModel) {
        Map<String, Shape> shapes = PruneUnsupportedShapesProcessor.copy(serviceModel.getShapes());
        serviceModel.getShapes().forEach((shapeName, shape) -> {
            if (PRUNE_CONDITIONS.stream().anyMatch(p -> p.test(shape))) {
                shapes.remove(shapeName);
                PruneUnsupportedShapesProcessor.log("Pruned shape [%s] that matched prune condition", shapeName);
            }
        });
        serviceModel.setShapes(shapes);
    }

    private static void doWhileShapesRemoved(ServiceModel serviceModel, Runnable runnable) {
        int numShapes;
        do {
            numShapes = serviceModel.getShapes().size();
            runnable.run();
        } while (serviceModel.getShapes().size() < numShapes);
    }

    private static void pruneCollectionShapes(ServiceModel serviceModel) {
        Map<String, Shape> shapes = PruneUnsupportedShapesProcessor.copy(serviceModel.getShapes());
        serviceModel.getShapes().forEach((shapeName, shape) -> {
            if (PruneUnsupportedShapesProcessor.isCollectionOfPrunedShape(shape, shapes)) {
                shapes.remove(shapeName);
                PruneUnsupportedShapesProcessor.log("Pruned collection-shape [%s]", shapeName);
            }
        });
        serviceModel.setShapes(shapes);
    }

    private static boolean isCollectionOfPrunedShape(Shape shape, Map<String, Shape> shapes) {
        if (Utils.isListShape(shape) && !shapes.containsKey(shape.getListMember().getShape())) {
            return true;
        }
        return Utils.isMapShape(shape) && (!shapes.containsKey(shape.getMapKeyType().getShape()) || !shapes.containsKey(shape.getMapValueType().getShape()));
    }

    private static void pruneShapeMembers(ServiceModel serviceModel) {
        Map<String, Shape> shapes = PruneUnsupportedShapesProcessor.copy(serviceModel.getShapes());
        serviceModel.getShapes().forEach((shapeName, shape) -> {
            Map<String, Member> members = PruneUnsupportedShapesProcessor.copy(shape.getMembers());
            for (Map.Entry<String, Member> entry : shape.getMembers().entrySet()) {
                String memberName = entry.getKey();
                Member member = entry.getValue();
                if (shapes.containsKey(member.getShape())) continue;
                if (shape.getRequired().contains(memberName)) {
                    shapes.remove(shapeName);
                    PruneUnsupportedShapesProcessor.log("Pruned shape [%s] with required member [%s]", shapeName, memberName);
                    break;
                }
                members.remove(memberName);
                PruneUnsupportedShapesProcessor.log("Pruned optional member [%s] from shape [%s]", memberName, shapeName);
                if (!memberName.equals(shape.getPayload())) continue;
                shape.setPayload(null);
                PruneUnsupportedShapesProcessor.log("Pruned payload trait for member [%s] from shape [%s]", memberName, shapeName);
            }
            shape.setMembers(members);
        });
        serviceModel.setShapes(shapes);
    }

    private static void pruneOperationsAndErrors(ServiceModel serviceModel) {
        Map<String, Shape> shapes = serviceModel.getShapes();
        Map<String, Operation> operations = PruneUnsupportedShapesProcessor.copy(serviceModel.getOperations());
        serviceModel.getOperations().forEach((operationName, operation) -> {
            String outputShape;
            String inputShape;
            if (operation.getInput() != null && !shapes.containsKey(inputShape = operation.getInput().getShape())) {
                operations.remove(operationName);
                PruneUnsupportedShapesProcessor.log("Pruned operation [%s] with input shape [%s]", operationName, inputShape);
                return;
            }
            if (operation.getOutput() != null && !shapes.containsKey(outputShape = operation.getOutput().getShape())) {
                operations.remove(operationName);
                PruneUnsupportedShapesProcessor.log("Pruned operation [%s] with output shape [%s]", operationName, outputShape);
                return;
            }
            List<ErrorMap> errors = PruneUnsupportedShapesProcessor.copy(operation.getErrors());
            operation.getErrors().forEach(error -> {
                String errorShape = error.getShape();
                if (!shapes.containsKey(errorShape)) {
                    errors.remove(error);
                    PruneUnsupportedShapesProcessor.log("Pruned error [%s] from operation [%s]", errorShape, operationName);
                }
            });
            operation.setErrors(errors);
        });
        serviceModel.setOperations(operations);
    }

    private static <K, V> Map<K, V> copy(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    private static <V> List<V> copy(List<V> list) {
        return new ArrayList<V>(list);
    }

    private static void log(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }
}

