/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddCustomAuthorizers;
import com.amazonaws.codegen.AddEmptyInputShape;
import com.amazonaws.codegen.AddEmptyOutputShape;
import com.amazonaws.codegen.AddExceptionShapes;
import com.amazonaws.codegen.AddInputShapes;
import com.amazonaws.codegen.AddMetadata;
import com.amazonaws.codegen.AddModelShapes;
import com.amazonaws.codegen.AddOperations;
import com.amazonaws.codegen.AddOutputShapes;
import com.amazonaws.codegen.AddWaiters;
import com.amazonaws.codegen.C2jModels;
import com.amazonaws.codegen.ExamplesCustomizer;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.RemoveUnusedShapes;
import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.customization.processors.DefaultCustomizationProcessor;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.AuthorizerModel;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.WaiterDefinitionModel;
import com.amazonaws.codegen.model.service.AuthType;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Waiters;
import com.amazonaws.codegen.naming.DefaultNamingStrategy;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IntermediateModelBuilder {
    private final CustomizationConfig customConfig;
    private final BasicCodeGenConfig codeGenConfig;
    private final ServiceModel service;
    private final ServiceExamples examples;
    private final NamingStrategy namingStrategy;
    private final TypeUtils typeUtils;
    private final List<IntermediateModelShapeProcessor> shapeProcessors;
    private final Waiters waiters;
    private final String codeGenBinDirectory;

    public IntermediateModelBuilder(C2jModels models, String codeGenBinDirectory) {
        this.customConfig = models.customizationConfig();
        this.codeGenConfig = models.codeGenConfig();
        this.service = models.serviceModel();
        this.examples = models.examplesModel();
        this.namingStrategy = new DefaultNamingStrategy(this.service, this.customConfig);
        this.typeUtils = new TypeUtils(this.namingStrategy);
        this.shapeProcessors = this.createShapeProcessors();
        this.waiters = models.waitersModel();
        this.codeGenBinDirectory = codeGenBinDirectory;
    }

    private List<IntermediateModelShapeProcessor> createShapeProcessors() {
        ArrayList<IntermediateModelShapeProcessor> processors = new ArrayList<IntermediateModelShapeProcessor>();
        processors.add(new AddInputShapes(this));
        processors.add(new AddOutputShapes(this));
        processors.add(new AddExceptionShapes(this));
        processors.add(new AddModelShapes(this));
        processors.add(new AddEmptyInputShape(this));
        processors.add(new AddEmptyOutputShape(this));
        return processors;
    }

    public IntermediateModel build() throws IOException {
        System.out.println("Applying customizations to examples...");
        new ExamplesCustomizer(this.service, this.customConfig).applyCustomizationsToExamples(this.examples);
        System.out.println("Examples customized.");
        CodegenCustomizationProcessor customization = DefaultCustomizationProcessor.getProcessorFor(this.customConfig);
        customization.preprocess(this.service);
        TreeMap<String, OperationModel> operations = new TreeMap<String, OperationModel>();
        HashMap<String, ShapeModel> shapes = new HashMap<String, ShapeModel>();
        HashMap<String, WaiterDefinitionModel> waiters = new HashMap<String, WaiterDefinitionModel>();
        HashMap<String, AuthorizerModel> authorizers = new HashMap<String, AuthorizerModel>();
        operations.putAll(new AddOperations(this).constructOperations());
        waiters.putAll(new AddWaiters(this.waiters, operations, this.codeGenBinDirectory).constructWaiters());
        authorizers.putAll(new AddCustomAuthorizers(this.service, this.getNamingStrategy()).constructAuthorizers());
        OperationModel endpointOperation = null;
        boolean endpointCacheRequired = false;
        for (OperationModel o : operations.values()) {
            if (o.isEndpointOperation()) {
                endpointOperation = o;
            }
            if (o.getEndpointDiscovery() == null || !o.getEndpointDiscovery().isRequired()) continue;
            endpointCacheRequired = true;
        }
        if (endpointOperation != null) {
            endpointOperation.setEndpointCacheRequired(endpointCacheRequired);
        }
        for (IntermediateModelShapeProcessor processor : this.shapeProcessors) {
            shapes.putAll(processor.process(Collections.unmodifiableMap(operations), Collections.unmodifiableMap(shapes)));
        }
        System.out.println(shapes.size() + " shapes found in total.");
        IntermediateModel fullModel = new IntermediateModel(AddMetadata.constructMetadata(this.service, this.codeGenConfig, this.customConfig), operations, shapes, this.customConfig, this.examples, endpointOperation, waiters, authorizers);
        customization.postprocess(fullModel);
        System.out.println(fullModel.getShapes().size() + " shapes remained after applying customizations.");
        Map<String, ShapeModel> trimmedShapes = RemoveUnusedShapes.removeUnusedShapes(fullModel);
        System.out.println(trimmedShapes.size() + " shapes remained after removing unused shapes.");
        IntermediateModel trimmedModel = new IntermediateModel(fullModel.getMetadata(), fullModel.getOperations(), trimmedShapes, fullModel.getCustomizationConfig(), fullModel.getExamples(), fullModel.getEndpointOperation(), fullModel.getWaiters(), fullModel.getCustomAuthorizers());
        this.linkMembersToShapes(trimmedModel);
        this.linkOperationsToInputOutputShapes(trimmedModel);
        this.linkCustomAuthorizationToRequestShapes(trimmedModel);
        return trimmedModel;
    }

    private void linkMembersToShapes(IntermediateModel model) {
        for (Map.Entry<String, ShapeModel> entry : model.getShapes().entrySet()) {
            if (entry.getValue().getMembers() == null) continue;
            for (MemberModel member : entry.getValue().getMembers()) {
                member.setShape(Utils.findShapeModelByC2jNameIfExists(model, member.getC2jShape()));
            }
        }
    }

    private void linkOperationsToInputOutputShapes(IntermediateModel model) {
        for (Map.Entry<String, OperationModel> entry : model.getOperations().entrySet()) {
            Operation operation = this.service.getOperations().get(entry.getKey());
            if (entry.getValue().getInput() != null) {
                entry.getValue().setInputShape(model.getShapes().get(entry.getValue().getInput().getSimpleType()));
            }
            if (operation.getOutput() == null) continue;
            String outputShapeName = operation.getOutput().getShape();
            if (!StringUtils.isNullOrEmpty((String)operation.getOutput().getResultWrapper())) continue;
            entry.getValue().setOutputShape(model.getShapeByC2jName(outputShapeName));
        }
    }

    private void linkCustomAuthorizationToRequestShapes(IntermediateModel model) {
        model.getOperations().values().stream().filter(OperationModel::isAuthenticated).forEach(operation -> {
            Operation c2jOperation = this.service.getOperation(operation.getOperationName());
            ShapeModel inputShape = operation.getInputShape();
            if (inputShape == null) {
                throw new IllegalStateException(String.format("Operation %s has unknown input shape", operation.getOperationName()));
            }
            if (model.getMetadata().getProtocol() == Protocol.API_GATEWAY) {
                this.linkCustomAuthorizationToRequestShapeForApiGatewayProtocol(model, c2jOperation, inputShape);
            } else {
                this.linkCustomAuthorizationToRequestShapeForAwsProtocol(c2jOperation.getAuthType(), inputShape);
            }
        });
    }

    private void linkCustomAuthorizationToRequestShapeForApiGatewayProtocol(IntermediateModel model, Operation c2jOperation, ShapeModel inputShape) {
        if (AuthType.CUSTOM.equals((Object)c2jOperation.getAuthType())) {
            AuthorizerModel auth = model.getCustomAuthorizers().get(c2jOperation.getAuthorizer());
            if (auth == null) {
                throw new IllegalStateException(String.format("Required custom auth not defined: %s", c2jOperation.getAuthorizer()));
            }
            inputShape.setRequestSignerClassFqcn(model.getMetadata().getPackageName() + ".auth." + auth.getInterfaceName());
        } else if (AuthType.IAM.equals((Object)c2jOperation.getAuthType())) {
            model.getMetadata().setRequiresIamSigners(true);
            inputShape.setRequestSignerClassFqcn("com.amazonaws.opensdk.protect.auth.IamRequestSigner");
        }
    }

    private void linkCustomAuthorizationToRequestShapeForAwsProtocol(AuthType authType, ShapeModel inputShape) {
        switch (authType) {
            case V4: {
                inputShape.setSignerType("AWS4SignerType");
                break;
            }
            case V4_UNSIGNED_BODY: {
                inputShape.setSignerType("AWS4UnsignedPayloadSignerType");
                break;
            }
            case NONE: 
            case IAM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authtype for AWS Request: " + (Object)((Object)authType));
            }
        }
    }

    public CustomizationConfig getCustomConfig() {
        return this.customConfig;
    }

    public BasicCodeGenConfig getCodeGenConfig() {
        return this.codeGenConfig;
    }

    public ServiceModel getService() {
        return this.service;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }
}

