/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.internal;

import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.config.templates.ChildTemplate;
import com.amazonaws.codegen.model.config.templates.CodeGenTemplatesConfig;
import com.amazonaws.codegen.model.config.templates.TopLevelTemplate;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.util.List;

public class Freemarker {
    private final CodeGenTemplatesConfig templateConfig;

    public static Freemarker create(IntermediateModel model) {
        return new Freemarker(Freemarker.loadProtocolTemplatesConfig(model));
    }

    private static CodeGenTemplatesConfig loadProtocolTemplatesConfig(IntermediateModel model) {
        Protocol templateProtocol = model.getMetadata().getProtocol();
        if (Protocol.CBOR.equals((Object)model.getMetadata().getProtocol()) || Protocol.ION.equals((Object)model.getMetadata().getProtocol())) {
            templateProtocol = Protocol.JSON;
        }
        CodeGenTemplatesConfig protocolDefaultConfig = CodeGenTemplatesConfig.load(templateProtocol);
        CustomizationConfig customConfig = model.getCustomizationConfig();
        if (customConfig == null || customConfig.getCustomCodeTemplates() == null) {
            return protocolDefaultConfig;
        }
        return CodeGenTemplatesConfig.merge(protocolDefaultConfig, customConfig.getCustomCodeTemplates());
    }

    private Freemarker(CodeGenTemplatesConfig templateConfig) {
        this.templateConfig = templateConfig;
    }

    private Configuration newFreeMarkerConfig() {
        Configuration freeMarkerConfig = new Configuration(Configuration.VERSION_2_3_24);
        freeMarkerConfig.setDefaultEncoding("UTF-8");
        freeMarkerConfig.setClassForTemplateLoading(this.getClass(), "/");
        freeMarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        return freeMarkerConfig;
    }

    private Template getTemplate(TopLevelTemplate template) throws IOException {
        Configuration fmConfig = this.newFreeMarkerConfig();
        Freemarker.importChildTemplates(fmConfig, this.templateConfig.getCommonChildTemplates());
        Freemarker.importChildTemplates(fmConfig, template.getChildTemplates());
        return fmConfig.getTemplate(template.getMainTemplate());
    }

    private static void importChildTemplates(Configuration freeMarkerConfig, List<ChildTemplate> childTemplates) {
        if (childTemplates == null) {
            return;
        }
        for (ChildTemplate template : childTemplates) {
            freeMarkerConfig.addAutoImport(template.getImportAsNamespace(), template.getLocation());
        }
    }

    public Template getSyncClientTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSyncClient());
    }

    public Template getSyncAbstractClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSyncAbstractClass());
    }

    public Template getSyncInterfaceTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSyncInterface());
    }

    public Template getAsyncClientTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAsyncClient());
    }

    public Template getAsyncAbstractClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAsyncAbstractClass());
    }

    public Template getAsyncInterfaceTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAsyncInterface());
    }

    public Template getSyncClientBuilderTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSyncClientBuilder());
    }

    public Template getAsyncClientBuilderTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAsyncClientBuilder());
    }

    public Template getRequestClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getRequestClass());
    }

    public Template getResponseClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getResponseClass());
    }

    public Template getModelClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelClass());
    }

    public Template getModelEnumTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelEnum());
    }

    public Template getModelMarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelMarshaller());
    }

    public Template getModelUnmarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelUnmarshaller());
    }

    public Template getExceptionClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getExceptionClass());
    }

    public Template getExceptionUnmarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getExceptionUnmarshaller());
    }

    public Template getPolicyActionClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getPolicyActionClass());
    }

    public Template getCucumberModuleInjectorTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberModuleInjector());
    }

    public Template getCucumberTestTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberTest());
    }

    public Template getCucumberPropertiesTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberPropertiesFile());
    }

    public Template getShapeTemplate(ShapeModel shape) throws IOException {
        switch (shape.getShapeType()) {
            case Request: {
                return this.getRequestClassTemplate();
            }
            case Response: {
                return this.getResponseClassTemplate();
            }
            case Model: {
                return this.getModelClassTemplate();
            }
            case Enum: {
                return this.getModelEnumTemplate();
            }
            case Exception: {
                return this.getExceptionClassTemplate();
            }
        }
        throw new RuntimeException("Unable to determine template for shape " + shape.getShapeName());
    }

    public Template getPackageInfoTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getPackageInfo());
    }

    public Template getBaseExceptionClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getBaseExceptionClass());
    }

    public Template getWaiterSDKFunctionTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSdkFunctionClass());
    }

    public Template getWaiterAcceptorTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAcceptorClass());
    }

    public Template getWaiterTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getWaiterClass());
    }
}

