/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.utils.FunctionalUtils;
import com.amazonaws.util.ImmutableMapParameter;
import freemarker.template.Template;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final String transformClassDir;
    private final Metadata metadata;
    private final Map<String, ShapeModel> shapes;

    public MarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.transformClassDir = dependencies.getPathProvider().getTransformDirectory();
        this.metadata = this.model.getMetadata();
        this.shapes = this.model.getShapes();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting marshaller classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).flatMap(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingMarshaller()) {
            System.out.println("Skip generating marshaller class for " + shapeModel.getShapeName());
            return false;
        }
        return this.shouldGenerate(shapeModel.getShapeType());
    }

    private boolean shouldGenerate(ShapeType shapeType) {
        return ShapeType.Request == shapeType || ShapeType.Model == shapeType && this.metadata.isJsonProtocol();
    }

    private Stream<GeneratorTask> createTask(String javaShapeName, ShapeModel shapeModel) throws Exception {
        if (shapeModel.getShapeType() == ShapeType.Request && this.metadata.isJsonProtocol()) {
            return Stream.of(this.createMarshallerTask(javaShapeName, this.freemarker.getRequestMarshallerTemplate(), javaShapeName + "ProtocolMarshaller"), this.createMarshallerTask(javaShapeName, this.freemarker.getModelMarshallerTemplate(), javaShapeName + "Marshaller"));
        }
        return Stream.of(this.createMarshallerTask(javaShapeName, this.freemarker.getModelMarshallerTemplate(), javaShapeName + "Marshaller"));
    }

    private GeneratorTask createMarshallerTask(String javaShapeName, Template template, String marshallerClassName) throws IOException {
        ImmutableMapParameter marshallerDataModel = ImmutableMapParameter.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shapeName", (Object)javaShapeName).put((Object)"shapes", this.shapes).put((Object)"metadata", (Object)this.metadata).put((Object)"transformPackage", (Object)this.model.getTransformPackage()).put((Object)"customConfig", (Object)this.model.getCustomizationConfig()).put((Object)"className", (Object)marshallerClassName).put((Object)"protocolEnum", (Object)this.getProtocolEnumName()).build();
        return new FreemarkerGeneratorTask(this.transformClassDir, marshallerClassName, template, marshallerDataModel);
    }

    private String getProtocolEnumName() {
        switch (this.metadata.getProtocol()) {
            case CBOR: 
            case ION: 
            case AWS_JSON: {
                return Protocol.AWS_JSON.name();
            }
        }
        return this.metadata.getProtocol().name();
    }
}

