/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.internal.Constants;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavaCodeFormatter {
    private final CodeFormatter codeFormatter;
    private static final Map<String, Object> DEFAULT_FORMATTER_OPTIONS = DefaultCodeFormatterConstants.getEclipseDefaultSettings();

    public JavaCodeFormatter() {
        this(new HashMap<String, Object>());
    }

    public JavaCodeFormatter(Map<String, Object> overrideOptions) {
        HashMap<String, Object> formatterOptions = new HashMap<String, Object>(DEFAULT_FORMATTER_OPTIONS);
        if (overrideOptions != null) {
            formatterOptions.putAll(overrideOptions);
        }
        this.codeFormatter = ToolFactory.createCodeFormatter(formatterOptions, (int)ToolFactory.M_FORMAT_EXISTING);
        if (this.codeFormatter == null) {
            throw new RuntimeException("Unable to create code formatter to format the generated code.");
        }
    }

    public String format(String contents) {
        TextEdit edit = this.codeFormatter.format(4104, contents, 0, contents.length(), 0, Constants.LINE_SEPARATOR);
        if (edit == null) {
            return contents;
        }
        Document document = new Document(contents);
        try {
            edit.apply((IDocument)document);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to format the generated source code.", e);
        }
        return document.get();
    }

    static {
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.compiler.source", "1.8");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.comment.indent_parameter_description", "false");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)1));
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.comment.format_header", "true");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.lineSplit", "160");
        DEFAULT_FORMATTER_OPTIONS.put("org.eclipse.jdt.core.formatter.comment.line_length", "120");
    }
}

