/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.ant.task;

import com.amazonaws.codegen.ant.task.CodeGenerator;
import com.amazonaws.codegen.internal.Jackson;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CodeGeneratorTask {
    private static final String P_MODEL_FILE = "modelFile";
    private static final String P_EXAMPLES_FILE = "examplesFile";
    private static final String P_CODEGEN_CONFIG_FILE = "codeGenConfigFile";
    private static final String P_CUSTOMIZATION_CONFIG_FILE = "customizationConfigFile";
    private static final String P_OUTPUT_DIRECTORY = "outputDirectory";
    private static final String MODEL_DIR_NAME = "models";

    public static void main(String[] args) throws IOException {
        String outputDirectory = Utils.getRequiredSystemProperty(P_OUTPUT_DIRECTORY, "Use -DoutputDirectory={path} to specify the output directory for the code generator.");
        ServiceModel serviceModel = CodeGeneratorTask.loadConfigurationModel(ServiceModel.class, CodeGeneratorTask.getModelFileClasspathLocation());
        String fileNamePrefix = serviceModel.getMetadata().getEndpointPrefix() + "-" + serviceModel.getMetadata().getApiVersion();
        CodeGenerator codeGenerator = new CodeGenerator(serviceModel, CodeGeneratorTask.getServiceExamples(), CodeGeneratorTask.getCodeGenConfig(), CodeGeneratorTask.getCustomizationConfig(), outputDirectory, fileNamePrefix);
        codeGenerator.execute();
        CodeGeneratorTask.snapshotServiceModelFile(fileNamePrefix, outputDirectory);
    }

    private static String getModelFileClasspathLocation() {
        return Utils.getRequiredSystemProperty(P_MODEL_FILE, "No C2j Model available for code generation. Use -DmodelFile={path} to specify the C2j model file.");
    }

    static File getModelDirectory(String outputDirectory) {
        File dir = new File(outputDirectory, MODEL_DIR_NAME);
        Utils.createDirectory(dir);
        return dir;
    }

    private static void snapshotServiceModelFile(String fileNamePrefix, String outputDirectory) throws IOException {
        try (InputStream is = Utils.getRequiredResourceAsStream(CodeGeneratorTask.class, CodeGeneratorTask.getModelFileClasspathLocation());){
            byte[] buf = new byte[2048];
            File modelDir = CodeGeneratorTask.getModelDirectory(outputDirectory);
            try (FileOutputStream fos = new FileOutputStream(new File(modelDir, fileNamePrefix + "-model.json"));){
                int len = is.read(buf);
                while (len > -1) {
                    fos.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
        }
    }

    private static BasicCodeGenConfig getCodeGenConfig() {
        String location = Utils.getRequiredSystemProperty(P_CODEGEN_CONFIG_FILE, "No codegen.config file available for code generation. Use -DcodeGenConfigFile={path} to specify the codegen.config file.");
        return CodeGeneratorTask.loadConfigurationModel(BasicCodeGenConfig.class, location);
    }

    private static CustomizationConfig getCustomizationConfig() {
        return CodeGeneratorTask.getCustomizationConfig(System.getProperty(P_CUSTOMIZATION_CONFIG_FILE));
    }

    private static CustomizationConfig getCustomizationConfig(String location) {
        if (Utils.isNullOrEmpty(location) && CodeGeneratorTask.class.getResource(location = "/customization.config") == null) {
            System.out.println("No customization.config file is specified");
            return new CustomizationConfig();
        }
        return CodeGeneratorTask.loadConfigurationModel(CustomizationConfig.class, location);
    }

    private static ServiceExamples getServiceExamples() {
        return CodeGeneratorTask.getServiceExamples(Utils.getOptionalSystemProperty(P_EXAMPLES_FILE));
    }

    private static ServiceExamples getServiceExamples(String location) {
        if (Utils.isNullOrEmpty(location)) {
            return new ServiceExamples();
        }
        return CodeGeneratorTask.loadConfigurationModel(ServiceExamples.class, location);
    }

    private static <T> T loadConfigurationModel(Class<T> clzz, String configurationFileLocation) {
        System.out.println("Loading config file " + configurationFileLocation);
        InputStream fileContents = null;
        try {
            fileContents = CodeGeneratorTask.getRequiredResourceAsStream(configurationFileLocation);
            T t = Jackson.load(clzz, fileContents);
            return t;
        }
        catch (IOException e) {
            System.err.println("Failed to read the configuration file " + configurationFileLocation);
            throw new RuntimeException(e);
        }
        finally {
            if (fileContents != null) {
                Utils.closeQuietly(fileContents);
            }
        }
    }

    private static InputStream getRequiredResourceAsStream(String location) {
        return Utils.getRequiredResourceAsStream(CodeGeneratorTask.class, location);
    }
}

