/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.AddEmptyInputShape;
import com.amazonaws.codegen.AddExceptionShapes;
import com.amazonaws.codegen.AddInputShapes;
import com.amazonaws.codegen.AddMetadata;
import com.amazonaws.codegen.AddModelShapes;
import com.amazonaws.codegen.AddOperations;
import com.amazonaws.codegen.AddOutputShapes;
import com.amazonaws.codegen.RemoveUnusedShapes;
import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.customization.processors.DefaultCustomizationProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class IntermediateModelBuilder {
    private final CustomizationConfig customConfig;
    private final BasicCodeGenConfig codeGenConfig;
    private final ServiceModel service;
    private final ServiceExamples examples;

    public IntermediateModelBuilder(CustomizationConfig customConfig, BasicCodeGenConfig codeGenConfig, ServiceModel service, ServiceExamples examples) {
        this.customConfig = customConfig;
        this.codeGenConfig = codeGenConfig;
        this.service = service;
        this.examples = examples;
    }

    public IntermediateModel build() {
        CodegenCustomizationProcessor customization = DefaultCustomizationProcessor.getProcessorFor(this.customConfig);
        customization.preprocess(this.service);
        TreeMap<String, OperationModel> operations = new TreeMap<String, OperationModel>();
        Map<String, ShapeModel> shapes = new HashMap<String, ShapeModel>();
        operations.putAll(AddOperations.constructOperations(this.service));
        shapes.putAll(new AddInputShapes(this.service, this.customConfig).constructInputShapes());
        shapes.putAll(new AddOutputShapes(this.service, this.customConfig).constructOutputShapes());
        shapes.putAll(new AddExceptionShapes(this.service, this.customConfig).constructExceptionShapes());
        shapes.putAll(new AddModelShapes(this.service, this.customConfig).constructModelShapes(shapes.keySet()));
        shapes.putAll(AddEmptyInputShape.addEmptyInputShapes(operations, this.service));
        System.out.println(shapes.size() + " shapes found in total.");
        IntermediateModel fullModel = new IntermediateModel(AddMetadata.constructMetadata(this.service, this.codeGenConfig, this.customConfig), operations, shapes, this.customConfig, this.examples);
        customization.postprocess(fullModel);
        System.out.println(fullModel.getShapes().size() + " shapes remained after applying customizations.");
        shapes = RemoveUnusedShapes.removeUnusedShapes(fullModel);
        System.out.println(shapes.size() + " shapes remained after removing unused shapes.");
        IntermediateModel trimmedModel = new IntermediateModel(fullModel.getMetadata(), fullModel.getOperations(), shapes, fullModel.getCustomizationConfig(), fullModel.getExamples());
        this.linkMembersToShapes(trimmedModel);
        return trimmedModel;
    }

    private void linkMembersToShapes(IntermediateModel model) {
        for (Map.Entry<String, ShapeModel> entry : model.getShapes().entrySet()) {
            if (entry.getValue().getMembers() == null) continue;
            for (MemberModel member : entry.getValue().getMembers()) {
                member.setShape(Utils.findShapeModelByC2jNameIfExists(model, member.getC2jShape()));
            }
        }
    }
}

