/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.emitters.JavaCodeFormatter;
import com.amazonaws.codegen.internal.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class CodeWriter
extends StringWriter {
    private final JavaCodeFormatter formatter = new JavaCodeFormatter();
    private final String dir;
    private final String file;

    public CodeWriter(String dir, String file) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException("Output Directory cannot be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("File name cannot be null.");
        }
        if (!file.endsWith(".java")) {
            file = file + ".java";
        }
        this.dir = dir;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(Utils.createFile(this.dir, this.file), "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String contents = this.getBuffer().toString();
            out.write(this.formatter.format(contents));
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(out);
            throw throwable;
        }
        Utils.closeQuietly(out);
    }
}

