/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchrum;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatchrum.AWSCloudWatchRUMAsync;
import com.amazonaws.services.cloudwatchrum.AWSCloudWatchRUMAsyncClientBuilder;
import com.amazonaws.services.cloudwatchrum.AWSCloudWatchRUMClient;
import com.amazonaws.services.cloudwatchrum.model.CreateAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.CreateAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.DeleteAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.DeleteAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorDataRequest;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorDataResult;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.GetAppMonitorResult;
import com.amazonaws.services.cloudwatchrum.model.ListAppMonitorsRequest;
import com.amazonaws.services.cloudwatchrum.model.ListAppMonitorsResult;
import com.amazonaws.services.cloudwatchrum.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudwatchrum.model.PutRumEventsRequest;
import com.amazonaws.services.cloudwatchrum.model.PutRumEventsResult;
import com.amazonaws.services.cloudwatchrum.model.TagResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.TagResourceResult;
import com.amazonaws.services.cloudwatchrum.model.UntagResourceRequest;
import com.amazonaws.services.cloudwatchrum.model.UntagResourceResult;
import com.amazonaws.services.cloudwatchrum.model.UpdateAppMonitorRequest;
import com.amazonaws.services.cloudwatchrum.model.UpdateAppMonitorResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCloudWatchRUMAsyncClient
extends AWSCloudWatchRUMClient
implements AWSCloudWatchRUMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCloudWatchRUMAsyncClientBuilder asyncBuilder() {
        return AWSCloudWatchRUMAsyncClientBuilder.standard();
    }

    AWSCloudWatchRUMAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCloudWatchRUMAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAppMonitorResult> createAppMonitorAsync(CreateAppMonitorRequest request) {
        return this.createAppMonitorAsync(request, null);
    }

    @Override
    public Future<CreateAppMonitorResult> createAppMonitorAsync(CreateAppMonitorRequest request, final AsyncHandler<CreateAppMonitorRequest, CreateAppMonitorResult> asyncHandler) {
        final CreateAppMonitorRequest finalRequest = (CreateAppMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAppMonitorResult>(){

            @Override
            public CreateAppMonitorResult call() throws Exception {
                CreateAppMonitorResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeCreateAppMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAppMonitorResult> deleteAppMonitorAsync(DeleteAppMonitorRequest request) {
        return this.deleteAppMonitorAsync(request, null);
    }

    @Override
    public Future<DeleteAppMonitorResult> deleteAppMonitorAsync(DeleteAppMonitorRequest request, final AsyncHandler<DeleteAppMonitorRequest, DeleteAppMonitorResult> asyncHandler) {
        final DeleteAppMonitorRequest finalRequest = (DeleteAppMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAppMonitorResult>(){

            @Override
            public DeleteAppMonitorResult call() throws Exception {
                DeleteAppMonitorResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeDeleteAppMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAppMonitorResult> getAppMonitorAsync(GetAppMonitorRequest request) {
        return this.getAppMonitorAsync(request, null);
    }

    @Override
    public Future<GetAppMonitorResult> getAppMonitorAsync(GetAppMonitorRequest request, final AsyncHandler<GetAppMonitorRequest, GetAppMonitorResult> asyncHandler) {
        final GetAppMonitorRequest finalRequest = (GetAppMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAppMonitorResult>(){

            @Override
            public GetAppMonitorResult call() throws Exception {
                GetAppMonitorResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeGetAppMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAppMonitorDataResult> getAppMonitorDataAsync(GetAppMonitorDataRequest request) {
        return this.getAppMonitorDataAsync(request, null);
    }

    @Override
    public Future<GetAppMonitorDataResult> getAppMonitorDataAsync(GetAppMonitorDataRequest request, final AsyncHandler<GetAppMonitorDataRequest, GetAppMonitorDataResult> asyncHandler) {
        final GetAppMonitorDataRequest finalRequest = (GetAppMonitorDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAppMonitorDataResult>(){

            @Override
            public GetAppMonitorDataResult call() throws Exception {
                GetAppMonitorDataResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeGetAppMonitorData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppMonitorsResult> listAppMonitorsAsync(ListAppMonitorsRequest request) {
        return this.listAppMonitorsAsync(request, null);
    }

    @Override
    public Future<ListAppMonitorsResult> listAppMonitorsAsync(ListAppMonitorsRequest request, final AsyncHandler<ListAppMonitorsRequest, ListAppMonitorsResult> asyncHandler) {
        final ListAppMonitorsRequest finalRequest = (ListAppMonitorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAppMonitorsResult>(){

            @Override
            public ListAppMonitorsResult call() throws Exception {
                ListAppMonitorsResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeListAppMonitors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRumEventsResult> putRumEventsAsync(PutRumEventsRequest request) {
        return this.putRumEventsAsync(request, null);
    }

    @Override
    public Future<PutRumEventsResult> putRumEventsAsync(PutRumEventsRequest request, final AsyncHandler<PutRumEventsRequest, PutRumEventsResult> asyncHandler) {
        final PutRumEventsRequest finalRequest = (PutRumEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRumEventsResult>(){

            @Override
            public PutRumEventsResult call() throws Exception {
                PutRumEventsResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executePutRumEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAppMonitorResult> updateAppMonitorAsync(UpdateAppMonitorRequest request) {
        return this.updateAppMonitorAsync(request, null);
    }

    @Override
    public Future<UpdateAppMonitorResult> updateAppMonitorAsync(UpdateAppMonitorRequest request, final AsyncHandler<UpdateAppMonitorRequest, UpdateAppMonitorResult> asyncHandler) {
        final UpdateAppMonitorRequest finalRequest = (UpdateAppMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAppMonitorResult>(){

            @Override
            public UpdateAppMonitorResult call() throws Exception {
                UpdateAppMonitorResult result = null;
                try {
                    result = AWSCloudWatchRUMAsyncClient.this.executeUpdateAppMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

