/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import java.util.concurrent.TimeUnit;

@NotThreadSafe
public class CloudWatchMetricConfig {
    static final String NAMESPACE_DELIMITER = "/";
    static final int MAX_METRICS_DATUM_SIZE = 20;
    public static final int DEFAULT_METRICS_QSIZE = 1000;
    public static final int DEFAULT_QUEUE_POLL_TIMEOUT_MILLI = (int)TimeUnit.MINUTES.toMillis(1L);
    private AWSCredentialsProvider credentialsProvider;
    private ClientConfiguration clientConfiguration;
    private long queuePollTimeoutMilli = DEFAULT_QUEUE_POLL_TIMEOUT_MILLI;
    @Deprecated
    private String cloudWatchEndPoint;
    private AwsClientBuilder.EndpointConfiguration endpointConfiguration;
    private int metricQueueSize = 1000;

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CloudWatchMetricConfig withCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.setCredentialsProvider(credentialsProvider);
        return this;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public CloudWatchMetricConfig withClientConfiguration(ClientConfiguration clientConfiguration) {
        this.setClientConfiguration(clientConfiguration);
        return this;
    }

    public long getQueuePollTimeoutMilli() {
        return this.queuePollTimeoutMilli;
    }

    public void setQueuePollTimeoutMilli(long queuePollTimeoutMilli) {
        this.queuePollTimeoutMilli = queuePollTimeoutMilli;
    }

    public CloudWatchMetricConfig withQueuePollTimeoutMilli(long queuePollTimeoutMilli) {
        this.setQueuePollTimeoutMilli(queuePollTimeoutMilli);
        return this;
    }

    public String getCloudWatchEndPoint() {
        return this.cloudWatchEndPoint;
    }

    @Deprecated
    public void setCloudWatchEndPoint(String cloudWatchEndPoint) {
        this.cloudWatchEndPoint = cloudWatchEndPoint;
    }

    @Deprecated
    public CloudWatchMetricConfig withCloudWatchEndPoint(String cloudWatchEndPoint) {
        this.setCloudWatchEndPoint(cloudWatchEndPoint);
        return this;
    }

    public AwsClientBuilder.EndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(AwsClientBuilder.EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public CloudWatchMetricConfig withEndpointConfiguration(AwsClientBuilder.EndpointConfiguration endpointConfiguration) {
        this.setEndpointConfiguration(endpointConfiguration);
        return this;
    }

    public int getMetricQueueSize() {
        return this.metricQueueSize;
    }

    public void setMetricQueueSize(int metricQueueSize) {
        if (metricQueueSize < 1) {
            throw new IllegalArgumentException();
        }
        this.metricQueueSize = metricQueueSize;
    }

    public CloudWatchMetricConfig withMetricQueueSize(int metricQueueSize) {
        this.setMetricQueueSize(metricQueueSize);
        return this;
    }
}

