/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentBaseStat;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentReportName;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentResultRequestType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetExperimentResultsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String baseStat;
    private Date endTime;
    private String experiment;
    private List<String> metricNames;
    private Long period;
    private String project;
    private List<String> reportNames;
    private List<String> resultStats;
    private Date startTime;
    private List<String> treatmentNames;

    public void setBaseStat(String baseStat) {
        this.baseStat = baseStat;
    }

    public String getBaseStat() {
        return this.baseStat;
    }

    public GetExperimentResultsRequest withBaseStat(String baseStat) {
        this.setBaseStat(baseStat);
        return this;
    }

    public GetExperimentResultsRequest withBaseStat(ExperimentBaseStat baseStat) {
        this.baseStat = baseStat.toString();
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetExperimentResultsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setExperiment(String experiment) {
        this.experiment = experiment;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public GetExperimentResultsRequest withExperiment(String experiment) {
        this.setExperiment(experiment);
        return this;
    }

    public List<String> getMetricNames() {
        return this.metricNames;
    }

    public void setMetricNames(Collection<String> metricNames) {
        if (metricNames == null) {
            this.metricNames = null;
            return;
        }
        this.metricNames = new ArrayList<String>(metricNames);
    }

    public GetExperimentResultsRequest withMetricNames(String ... metricNames) {
        if (this.metricNames == null) {
            this.setMetricNames(new ArrayList<String>(metricNames.length));
        }
        for (String ele : metricNames) {
            this.metricNames.add(ele);
        }
        return this;
    }

    public GetExperimentResultsRequest withMetricNames(Collection<String> metricNames) {
        this.setMetricNames(metricNames);
        return this;
    }

    public void setPeriod(Long period) {
        this.period = period;
    }

    public Long getPeriod() {
        return this.period;
    }

    public GetExperimentResultsRequest withPeriod(Long period) {
        this.setPeriod(period);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public GetExperimentResultsRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public List<String> getReportNames() {
        return this.reportNames;
    }

    public void setReportNames(Collection<String> reportNames) {
        if (reportNames == null) {
            this.reportNames = null;
            return;
        }
        this.reportNames = new ArrayList<String>(reportNames);
    }

    public GetExperimentResultsRequest withReportNames(String ... reportNames) {
        if (this.reportNames == null) {
            this.setReportNames(new ArrayList<String>(reportNames.length));
        }
        for (String ele : reportNames) {
            this.reportNames.add(ele);
        }
        return this;
    }

    public GetExperimentResultsRequest withReportNames(Collection<String> reportNames) {
        this.setReportNames(reportNames);
        return this;
    }

    public GetExperimentResultsRequest withReportNames(ExperimentReportName ... reportNames) {
        ArrayList<String> reportNamesCopy = new ArrayList<String>(reportNames.length);
        for (ExperimentReportName value : reportNames) {
            reportNamesCopy.add(value.toString());
        }
        if (this.getReportNames() == null) {
            this.setReportNames(reportNamesCopy);
        } else {
            this.getReportNames().addAll(reportNamesCopy);
        }
        return this;
    }

    public List<String> getResultStats() {
        return this.resultStats;
    }

    public void setResultStats(Collection<String> resultStats) {
        if (resultStats == null) {
            this.resultStats = null;
            return;
        }
        this.resultStats = new ArrayList<String>(resultStats);
    }

    public GetExperimentResultsRequest withResultStats(String ... resultStats) {
        if (this.resultStats == null) {
            this.setResultStats(new ArrayList<String>(resultStats.length));
        }
        for (String ele : resultStats) {
            this.resultStats.add(ele);
        }
        return this;
    }

    public GetExperimentResultsRequest withResultStats(Collection<String> resultStats) {
        this.setResultStats(resultStats);
        return this;
    }

    public GetExperimentResultsRequest withResultStats(ExperimentResultRequestType ... resultStats) {
        ArrayList<String> resultStatsCopy = new ArrayList<String>(resultStats.length);
        for (ExperimentResultRequestType value : resultStats) {
            resultStatsCopy.add(value.toString());
        }
        if (this.getResultStats() == null) {
            this.setResultStats(resultStatsCopy);
        } else {
            this.getResultStats().addAll(resultStatsCopy);
        }
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetExperimentResultsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public List<String> getTreatmentNames() {
        return this.treatmentNames;
    }

    public void setTreatmentNames(Collection<String> treatmentNames) {
        if (treatmentNames == null) {
            this.treatmentNames = null;
            return;
        }
        this.treatmentNames = new ArrayList<String>(treatmentNames);
    }

    public GetExperimentResultsRequest withTreatmentNames(String ... treatmentNames) {
        if (this.treatmentNames == null) {
            this.setTreatmentNames(new ArrayList<String>(treatmentNames.length));
        }
        for (String ele : treatmentNames) {
            this.treatmentNames.add(ele);
        }
        return this;
    }

    public GetExperimentResultsRequest withTreatmentNames(Collection<String> treatmentNames) {
        this.setTreatmentNames(treatmentNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBaseStat() != null) {
            sb.append("BaseStat: ").append(this.getBaseStat()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getExperiment() != null) {
            sb.append("Experiment: ").append(this.getExperiment()).append(",");
        }
        if (this.getMetricNames() != null) {
            sb.append("MetricNames: ").append(this.getMetricNames()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getReportNames() != null) {
            sb.append("ReportNames: ").append(this.getReportNames()).append(",");
        }
        if (this.getResultStats() != null) {
            sb.append("ResultStats: ").append(this.getResultStats()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getTreatmentNames() != null) {
            sb.append("TreatmentNames: ").append(this.getTreatmentNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentResultsRequest)) {
            return false;
        }
        GetExperimentResultsRequest other = (GetExperimentResultsRequest)obj;
        if (other.getBaseStat() == null ^ this.getBaseStat() == null) {
            return false;
        }
        if (other.getBaseStat() != null && !other.getBaseStat().equals(this.getBaseStat())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getExperiment() == null ^ this.getExperiment() == null) {
            return false;
        }
        if (other.getExperiment() != null && !other.getExperiment().equals(this.getExperiment())) {
            return false;
        }
        if (other.getMetricNames() == null ^ this.getMetricNames() == null) {
            return false;
        }
        if (other.getMetricNames() != null && !other.getMetricNames().equals(this.getMetricNames())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getReportNames() == null ^ this.getReportNames() == null) {
            return false;
        }
        if (other.getReportNames() != null && !other.getReportNames().equals(this.getReportNames())) {
            return false;
        }
        if (other.getResultStats() == null ^ this.getResultStats() == null) {
            return false;
        }
        if (other.getResultStats() != null && !other.getResultStats().equals(this.getResultStats())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getTreatmentNames() == null ^ this.getTreatmentNames() == null) {
            return false;
        }
        return other.getTreatmentNames() == null || other.getTreatmentNames().equals(this.getTreatmentNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBaseStat() == null ? 0 : this.getBaseStat().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getExperiment() == null ? 0 : this.getExperiment().hashCode());
        hashCode = 31 * hashCode + (this.getMetricNames() == null ? 0 : this.getMetricNames().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getReportNames() == null ? 0 : this.getReportNames().hashCode());
        hashCode = 31 * hashCode + (this.getResultStats() == null ? 0 : this.getResultStats().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTreatmentNames() == null ? 0 : this.getTreatmentNames().hashCode());
        return hashCode;
    }

    public GetExperimentResultsRequest clone() {
        return (GetExperimentResultsRequest)super.clone();
    }
}

