/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/evidently-2021-02-01/PutProjectEvents" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutProjectEventsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * An array of event structures that contain the performance data that is being sent to Evidently.
     * </p>
     */
    private java.util.List<Event> events;
    /**
     * <p>
     * The name or ARN of the project to write the events to.
     * </p>
     */
    private String project;

    /**
     * <p>
     * An array of event structures that contain the performance data that is being sent to Evidently.
     * </p>
     * 
     * @return An array of event structures that contain the performance data that is being sent to Evidently.
     */

    public java.util.List<Event> getEvents() {
        return events;
    }

    /**
     * <p>
     * An array of event structures that contain the performance data that is being sent to Evidently.
     * </p>
     * 
     * @param events
     *        An array of event structures that contain the performance data that is being sent to Evidently.
     */

    public void setEvents(java.util.Collection<Event> events) {
        if (events == null) {
            this.events = null;
            return;
        }

        this.events = new java.util.ArrayList<Event>(events);
    }

    /**
     * <p>
     * An array of event structures that contain the performance data that is being sent to Evidently.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param events
     *        An array of event structures that contain the performance data that is being sent to Evidently.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutProjectEventsRequest withEvents(Event... events) {
        if (this.events == null) {
            setEvents(new java.util.ArrayList<Event>(events.length));
        }
        for (Event ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of event structures that contain the performance data that is being sent to Evidently.
     * </p>
     * 
     * @param events
     *        An array of event structures that contain the performance data that is being sent to Evidently.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutProjectEventsRequest withEvents(java.util.Collection<Event> events) {
        setEvents(events);
        return this;
    }

    /**
     * <p>
     * The name or ARN of the project to write the events to.
     * </p>
     * 
     * @param project
     *        The name or ARN of the project to write the events to.
     */

    public void setProject(String project) {
        this.project = project;
    }

    /**
     * <p>
     * The name or ARN of the project to write the events to.
     * </p>
     * 
     * @return The name or ARN of the project to write the events to.
     */

    public String getProject() {
        return this.project;
    }

    /**
     * <p>
     * The name or ARN of the project to write the events to.
     * </p>
     * 
     * @param project
     *        The name or ARN of the project to write the events to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutProjectEventsRequest withProject(String project) {
        setProject(project);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEvents() != null)
            sb.append("Events: ").append(getEvents()).append(",");
        if (getProject() != null)
            sb.append("Project: ").append(getProject());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutProjectEventsRequest == false)
            return false;
        PutProjectEventsRequest other = (PutProjectEventsRequest) obj;
        if (other.getEvents() == null ^ this.getEvents() == null)
            return false;
        if (other.getEvents() != null && other.getEvents().equals(this.getEvents()) == false)
            return false;
        if (other.getProject() == null ^ this.getProject() == null)
            return false;
        if (other.getProject() != null && other.getProject().equals(this.getProject()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEvents() == null) ? 0 : getEvents().hashCode());
        hashCode = prime * hashCode + ((getProject() == null) ? 0 : getProject().hashCode());
        return hashCode;
    }

    @Override
    public PutProjectEventsRequest clone() {
        return (PutProjectEventsRequest) super.clone();
    }

}
