/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentExecution;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentSchedule;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentStatus;
import com.amazonaws.services.cloudwatchevidently.model.ExperimentType;
import com.amazonaws.services.cloudwatchevidently.model.MetricGoal;
import com.amazonaws.services.cloudwatchevidently.model.OnlineAbDefinition;
import com.amazonaws.services.cloudwatchevidently.model.Treatment;
import com.amazonaws.services.cloudwatchevidently.model.transform.ExperimentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Experiment
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdTime;
    private String description;
    private ExperimentExecution execution;
    private Date lastUpdatedTime;
    private List<MetricGoal> metricGoals;
    private String name;
    private OnlineAbDefinition onlineAbDefinition;
    private String project;
    private String randomizationSalt;
    private Long samplingRate;
    private ExperimentSchedule schedule;
    private String segment;
    private String status;
    private String statusReason;
    private Map<String, String> tags;
    private List<Treatment> treatments;
    private String type;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Experiment withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Experiment withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Experiment withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setExecution(ExperimentExecution execution) {
        this.execution = execution;
    }

    public ExperimentExecution getExecution() {
        return this.execution;
    }

    public Experiment withExecution(ExperimentExecution execution) {
        this.setExecution(execution);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Experiment withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public List<MetricGoal> getMetricGoals() {
        return this.metricGoals;
    }

    public void setMetricGoals(Collection<MetricGoal> metricGoals) {
        if (metricGoals == null) {
            this.metricGoals = null;
            return;
        }
        this.metricGoals = new ArrayList<MetricGoal>(metricGoals);
    }

    public Experiment withMetricGoals(MetricGoal ... metricGoals) {
        if (this.metricGoals == null) {
            this.setMetricGoals(new ArrayList<MetricGoal>(metricGoals.length));
        }
        for (MetricGoal ele : metricGoals) {
            this.metricGoals.add(ele);
        }
        return this;
    }

    public Experiment withMetricGoals(Collection<MetricGoal> metricGoals) {
        this.setMetricGoals(metricGoals);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Experiment withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOnlineAbDefinition(OnlineAbDefinition onlineAbDefinition) {
        this.onlineAbDefinition = onlineAbDefinition;
    }

    public OnlineAbDefinition getOnlineAbDefinition() {
        return this.onlineAbDefinition;
    }

    public Experiment withOnlineAbDefinition(OnlineAbDefinition onlineAbDefinition) {
        this.setOnlineAbDefinition(onlineAbDefinition);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public Experiment withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setRandomizationSalt(String randomizationSalt) {
        this.randomizationSalt = randomizationSalt;
    }

    public String getRandomizationSalt() {
        return this.randomizationSalt;
    }

    public Experiment withRandomizationSalt(String randomizationSalt) {
        this.setRandomizationSalt(randomizationSalt);
        return this;
    }

    public void setSamplingRate(Long samplingRate) {
        this.samplingRate = samplingRate;
    }

    public Long getSamplingRate() {
        return this.samplingRate;
    }

    public Experiment withSamplingRate(Long samplingRate) {
        this.setSamplingRate(samplingRate);
        return this;
    }

    public void setSchedule(ExperimentSchedule schedule) {
        this.schedule = schedule;
    }

    public ExperimentSchedule getSchedule() {
        return this.schedule;
    }

    public Experiment withSchedule(ExperimentSchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public String getSegment() {
        return this.segment;
    }

    public Experiment withSegment(String segment) {
        this.setSegment(segment);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Experiment withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Experiment withStatus(ExperimentStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public Experiment withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Experiment withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Experiment addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Experiment clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<Treatment> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(Collection<Treatment> treatments) {
        if (treatments == null) {
            this.treatments = null;
            return;
        }
        this.treatments = new ArrayList<Treatment>(treatments);
    }

    public Experiment withTreatments(Treatment ... treatments) {
        if (this.treatments == null) {
            this.setTreatments(new ArrayList<Treatment>(treatments.length));
        }
        for (Treatment ele : treatments) {
            this.treatments.add(ele);
        }
        return this;
    }

    public Experiment withTreatments(Collection<Treatment> treatments) {
        this.setTreatments(treatments);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Experiment withType(String type) {
        this.setType(type);
        return this;
    }

    public Experiment withType(ExperimentType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getExecution() != null) {
            sb.append("Execution: ").append(this.getExecution()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getMetricGoals() != null) {
            sb.append("MetricGoals: ").append(this.getMetricGoals()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOnlineAbDefinition() != null) {
            sb.append("OnlineAbDefinition: ").append(this.getOnlineAbDefinition()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRandomizationSalt() != null) {
            sb.append("RandomizationSalt: ").append(this.getRandomizationSalt()).append(",");
        }
        if (this.getSamplingRate() != null) {
            sb.append("SamplingRate: ").append(this.getSamplingRate()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getSegment() != null) {
            sb.append("Segment: ").append(this.getSegment()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTreatments() != null) {
            sb.append("Treatments: ").append(this.getTreatments()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getExecution() == null ^ this.getExecution() == null) {
            return false;
        }
        if (other.getExecution() != null && !other.getExecution().equals(this.getExecution())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getMetricGoals() == null ^ this.getMetricGoals() == null) {
            return false;
        }
        if (other.getMetricGoals() != null && !other.getMetricGoals().equals(this.getMetricGoals())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOnlineAbDefinition() == null ^ this.getOnlineAbDefinition() == null) {
            return false;
        }
        if (other.getOnlineAbDefinition() != null && !other.getOnlineAbDefinition().equals(this.getOnlineAbDefinition())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRandomizationSalt() == null ^ this.getRandomizationSalt() == null) {
            return false;
        }
        if (other.getRandomizationSalt() != null && !other.getRandomizationSalt().equals(this.getRandomizationSalt())) {
            return false;
        }
        if (other.getSamplingRate() == null ^ this.getSamplingRate() == null) {
            return false;
        }
        if (other.getSamplingRate() != null && !other.getSamplingRate().equals(this.getSamplingRate())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        if (other.getSegment() != null && !other.getSegment().equals(this.getSegment())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTreatments() == null ^ this.getTreatments() == null) {
            return false;
        }
        if (other.getTreatments() != null && !other.getTreatments().equals(this.getTreatments())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getExecution() == null ? 0 : this.getExecution().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getMetricGoals() == null ? 0 : this.getMetricGoals().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOnlineAbDefinition() == null ? 0 : this.getOnlineAbDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRandomizationSalt() == null ? 0 : this.getRandomizationSalt().hashCode());
        hashCode = 31 * hashCode + (this.getSamplingRate() == null ? 0 : this.getSamplingRate().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTreatments() == null ? 0 : this.getTreatments().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Experiment clone() {
        try {
            return (Experiment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

