/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.MetricGoalConfig;
import com.amazonaws.services.cloudwatchevidently.model.OnlineAbConfig;
import com.amazonaws.services.cloudwatchevidently.model.TreatmentConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateExperimentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<MetricGoalConfig> metricGoals;
    private String name;
    private OnlineAbConfig onlineAbConfig;
    private String project;
    private String randomizationSalt;
    private Long samplingRate;
    private String segment;
    private Map<String, String> tags;
    private List<TreatmentConfig> treatments;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateExperimentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<MetricGoalConfig> getMetricGoals() {
        return this.metricGoals;
    }

    public void setMetricGoals(Collection<MetricGoalConfig> metricGoals) {
        if (metricGoals == null) {
            this.metricGoals = null;
            return;
        }
        this.metricGoals = new ArrayList<MetricGoalConfig>(metricGoals);
    }

    public CreateExperimentRequest withMetricGoals(MetricGoalConfig ... metricGoals) {
        if (this.metricGoals == null) {
            this.setMetricGoals(new ArrayList<MetricGoalConfig>(metricGoals.length));
        }
        for (MetricGoalConfig ele : metricGoals) {
            this.metricGoals.add(ele);
        }
        return this;
    }

    public CreateExperimentRequest withMetricGoals(Collection<MetricGoalConfig> metricGoals) {
        this.setMetricGoals(metricGoals);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateExperimentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOnlineAbConfig(OnlineAbConfig onlineAbConfig) {
        this.onlineAbConfig = onlineAbConfig;
    }

    public OnlineAbConfig getOnlineAbConfig() {
        return this.onlineAbConfig;
    }

    public CreateExperimentRequest withOnlineAbConfig(OnlineAbConfig onlineAbConfig) {
        this.setOnlineAbConfig(onlineAbConfig);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public CreateExperimentRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setRandomizationSalt(String randomizationSalt) {
        this.randomizationSalt = randomizationSalt;
    }

    public String getRandomizationSalt() {
        return this.randomizationSalt;
    }

    public CreateExperimentRequest withRandomizationSalt(String randomizationSalt) {
        this.setRandomizationSalt(randomizationSalt);
        return this;
    }

    public void setSamplingRate(Long samplingRate) {
        this.samplingRate = samplingRate;
    }

    public Long getSamplingRate() {
        return this.samplingRate;
    }

    public CreateExperimentRequest withSamplingRate(Long samplingRate) {
        this.setSamplingRate(samplingRate);
        return this;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public String getSegment() {
        return this.segment;
    }

    public CreateExperimentRequest withSegment(String segment) {
        this.setSegment(segment);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateExperimentRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateExperimentRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateExperimentRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<TreatmentConfig> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(Collection<TreatmentConfig> treatments) {
        if (treatments == null) {
            this.treatments = null;
            return;
        }
        this.treatments = new ArrayList<TreatmentConfig>(treatments);
    }

    public CreateExperimentRequest withTreatments(TreatmentConfig ... treatments) {
        if (this.treatments == null) {
            this.setTreatments(new ArrayList<TreatmentConfig>(treatments.length));
        }
        for (TreatmentConfig ele : treatments) {
            this.treatments.add(ele);
        }
        return this;
    }

    public CreateExperimentRequest withTreatments(Collection<TreatmentConfig> treatments) {
        this.setTreatments(treatments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getMetricGoals() != null) {
            sb.append("MetricGoals: ").append(this.getMetricGoals()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOnlineAbConfig() != null) {
            sb.append("OnlineAbConfig: ").append(this.getOnlineAbConfig()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRandomizationSalt() != null) {
            sb.append("RandomizationSalt: ").append(this.getRandomizationSalt()).append(",");
        }
        if (this.getSamplingRate() != null) {
            sb.append("SamplingRate: ").append(this.getSamplingRate()).append(",");
        }
        if (this.getSegment() != null) {
            sb.append("Segment: ").append(this.getSegment()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTreatments() != null) {
            sb.append("Treatments: ").append(this.getTreatments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentRequest)) {
            return false;
        }
        CreateExperimentRequest other = (CreateExperimentRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getMetricGoals() == null ^ this.getMetricGoals() == null) {
            return false;
        }
        if (other.getMetricGoals() != null && !other.getMetricGoals().equals(this.getMetricGoals())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOnlineAbConfig() == null ^ this.getOnlineAbConfig() == null) {
            return false;
        }
        if (other.getOnlineAbConfig() != null && !other.getOnlineAbConfig().equals(this.getOnlineAbConfig())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRandomizationSalt() == null ^ this.getRandomizationSalt() == null) {
            return false;
        }
        if (other.getRandomizationSalt() != null && !other.getRandomizationSalt().equals(this.getRandomizationSalt())) {
            return false;
        }
        if (other.getSamplingRate() == null ^ this.getSamplingRate() == null) {
            return false;
        }
        if (other.getSamplingRate() != null && !other.getSamplingRate().equals(this.getSamplingRate())) {
            return false;
        }
        if (other.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        if (other.getSegment() != null && !other.getSegment().equals(this.getSegment())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTreatments() == null ^ this.getTreatments() == null) {
            return false;
        }
        return other.getTreatments() == null || other.getTreatments().equals(this.getTreatments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getMetricGoals() == null ? 0 : this.getMetricGoals().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOnlineAbConfig() == null ? 0 : this.getOnlineAbConfig().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRandomizationSalt() == null ? 0 : this.getRandomizationSalt().hashCode());
        hashCode = 31 * hashCode + (this.getSamplingRate() == null ? 0 : this.getSamplingRate().hashCode());
        hashCode = 31 * hashCode + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTreatments() == null ? 0 : this.getTreatments().hashCode());
        return hashCode;
    }

    public CreateExperimentRequest clone() {
        return (CreateExperimentRequest)super.clone();
    }
}

