/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cloudwatchevidently.model.FeatureSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFeaturesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FeatureSummary> features;
    private String nextToken;

    public List<FeatureSummary> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<FeatureSummary> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<FeatureSummary>(features);
    }

    public ListFeaturesResult withFeatures(FeatureSummary ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<FeatureSummary>(features.length));
        }
        for (FeatureSummary ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public ListFeaturesResult withFeatures(Collection<FeatureSummary> features) {
        this.setFeatures(features);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFeaturesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeaturesResult)) {
            return false;
        }
        ListFeaturesResult other = (ListFeaturesResult)obj;
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        if (other.getFeatures() != null && !other.getFeatures().equals(this.getFeatures())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListFeaturesResult clone() {
        try {
            return (ListFeaturesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

