/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.transform.SegmentOverrideMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SegmentOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private Long evaluationOrder;
    private String segment;
    private Map<String, Long> weights;

    public void setEvaluationOrder(Long evaluationOrder) {
        this.evaluationOrder = evaluationOrder;
    }

    public Long getEvaluationOrder() {
        return this.evaluationOrder;
    }

    public SegmentOverride withEvaluationOrder(Long evaluationOrder) {
        this.setEvaluationOrder(evaluationOrder);
        return this;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }

    public String getSegment() {
        return this.segment;
    }

    public SegmentOverride withSegment(String segment) {
        this.setSegment(segment);
        return this;
    }

    public Map<String, Long> getWeights() {
        return this.weights;
    }

    public void setWeights(Map<String, Long> weights) {
        this.weights = weights;
    }

    public SegmentOverride withWeights(Map<String, Long> weights) {
        this.setWeights(weights);
        return this;
    }

    public SegmentOverride addWeightsEntry(String key, Long value) {
        if (null == this.weights) {
            this.weights = new HashMap<String, Long>();
        }
        if (this.weights.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.weights.put(key, value);
        return this;
    }

    public SegmentOverride clearWeightsEntries() {
        this.weights = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluationOrder() != null) {
            sb.append("EvaluationOrder: ").append(this.getEvaluationOrder()).append(",");
        }
        if (this.getSegment() != null) {
            sb.append("Segment: ").append(this.getSegment()).append(",");
        }
        if (this.getWeights() != null) {
            sb.append("Weights: ").append(this.getWeights());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentOverride)) {
            return false;
        }
        SegmentOverride other = (SegmentOverride)obj;
        if (other.getEvaluationOrder() == null ^ this.getEvaluationOrder() == null) {
            return false;
        }
        if (other.getEvaluationOrder() != null && !other.getEvaluationOrder().equals(this.getEvaluationOrder())) {
            return false;
        }
        if (other.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        if (other.getSegment() != null && !other.getSegment().equals(this.getSegment())) {
            return false;
        }
        if (other.getWeights() == null ^ this.getWeights() == null) {
            return false;
        }
        return other.getWeights() == null || other.getWeights().equals(this.getWeights());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluationOrder() == null ? 0 : this.getEvaluationOrder().hashCode());
        hashCode = 31 * hashCode + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        hashCode = 31 * hashCode + (this.getWeights() == null ? 0 : this.getWeights().hashCode());
        return hashCode;
    }

    public SegmentOverride clone() {
        try {
            return (SegmentOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

