/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cloudwatchevidently.model.LaunchGroupConfig;
import com.amazonaws.services.cloudwatchevidently.model.MetricMonitorConfig;
import com.amazonaws.services.cloudwatchevidently.model.ScheduledSplitsLaunchConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateLaunchRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private List<LaunchGroupConfig> groups;
    private List<MetricMonitorConfig> metricMonitors;
    private String name;
    private String project;
    private String randomizationSalt;
    private ScheduledSplitsLaunchConfig scheduledSplitsConfig;
    private Map<String, String> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateLaunchRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<LaunchGroupConfig> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<LaunchGroupConfig> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<LaunchGroupConfig>(groups);
    }

    public CreateLaunchRequest withGroups(LaunchGroupConfig ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<LaunchGroupConfig>(groups.length));
        }
        for (LaunchGroupConfig ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public CreateLaunchRequest withGroups(Collection<LaunchGroupConfig> groups) {
        this.setGroups(groups);
        return this;
    }

    public List<MetricMonitorConfig> getMetricMonitors() {
        return this.metricMonitors;
    }

    public void setMetricMonitors(Collection<MetricMonitorConfig> metricMonitors) {
        if (metricMonitors == null) {
            this.metricMonitors = null;
            return;
        }
        this.metricMonitors = new ArrayList<MetricMonitorConfig>(metricMonitors);
    }

    public CreateLaunchRequest withMetricMonitors(MetricMonitorConfig ... metricMonitors) {
        if (this.metricMonitors == null) {
            this.setMetricMonitors(new ArrayList<MetricMonitorConfig>(metricMonitors.length));
        }
        for (MetricMonitorConfig ele : metricMonitors) {
            this.metricMonitors.add(ele);
        }
        return this;
    }

    public CreateLaunchRequest withMetricMonitors(Collection<MetricMonitorConfig> metricMonitors) {
        this.setMetricMonitors(metricMonitors);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateLaunchRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public CreateLaunchRequest withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setRandomizationSalt(String randomizationSalt) {
        this.randomizationSalt = randomizationSalt;
    }

    public String getRandomizationSalt() {
        return this.randomizationSalt;
    }

    public CreateLaunchRequest withRandomizationSalt(String randomizationSalt) {
        this.setRandomizationSalt(randomizationSalt);
        return this;
    }

    public void setScheduledSplitsConfig(ScheduledSplitsLaunchConfig scheduledSplitsConfig) {
        this.scheduledSplitsConfig = scheduledSplitsConfig;
    }

    public ScheduledSplitsLaunchConfig getScheduledSplitsConfig() {
        return this.scheduledSplitsConfig;
    }

    public CreateLaunchRequest withScheduledSplitsConfig(ScheduledSplitsLaunchConfig scheduledSplitsConfig) {
        this.setScheduledSplitsConfig(scheduledSplitsConfig);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateLaunchRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateLaunchRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateLaunchRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getMetricMonitors() != null) {
            sb.append("MetricMonitors: ").append(this.getMetricMonitors()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getRandomizationSalt() != null) {
            sb.append("RandomizationSalt: ").append(this.getRandomizationSalt()).append(",");
        }
        if (this.getScheduledSplitsConfig() != null) {
            sb.append("ScheduledSplitsConfig: ").append(this.getScheduledSplitsConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchRequest)) {
            return false;
        }
        CreateLaunchRequest other = (CreateLaunchRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getMetricMonitors() == null ^ this.getMetricMonitors() == null) {
            return false;
        }
        if (other.getMetricMonitors() != null && !other.getMetricMonitors().equals(this.getMetricMonitors())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getRandomizationSalt() == null ^ this.getRandomizationSalt() == null) {
            return false;
        }
        if (other.getRandomizationSalt() != null && !other.getRandomizationSalt().equals(this.getRandomizationSalt())) {
            return false;
        }
        if (other.getScheduledSplitsConfig() == null ^ this.getScheduledSplitsConfig() == null) {
            return false;
        }
        if (other.getScheduledSplitsConfig() != null && !other.getScheduledSplitsConfig().equals(this.getScheduledSplitsConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getMetricMonitors() == null ? 0 : this.getMetricMonitors().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getRandomizationSalt() == null ? 0 : this.getRandomizationSalt().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledSplitsConfig() == null ? 0 : this.getScheduledSplitsConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateLaunchRequest clone() {
        return (CreateLaunchRequest)super.clone();
    }
}

