/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.DashboardEntry;
import java.util.Date;

@SdkInternalApi
public class DashboardEntryMarshaller {
    private static final MarshallingInfo<String> DASHBOARDNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DashboardName").build();
    private static final MarshallingInfo<String> DASHBOARDARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DashboardArn").build();
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final DashboardEntryMarshaller instance = new DashboardEntryMarshaller();

    public static DashboardEntryMarshaller getInstance() {
        return instance;
    }

    public void marshall(DashboardEntry dashboardEntry, ProtocolMarshaller protocolMarshaller) {
        if (dashboardEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dashboardEntry.getDashboardName(), DASHBOARDNAME_BINDING);
            protocolMarshaller.marshall((Object)dashboardEntry.getDashboardArn(), DASHBOARDARN_BINDING);
            protocolMarshaller.marshall((Object)dashboardEntry.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)dashboardEntry.getSize(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

