/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.MetricStreamStatisticsConfiguration;
import java.util.List;

@SdkInternalApi
public class MetricStreamStatisticsConfigurationMarshaller {
    private static final MarshallingInfo<List> INCLUDEMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeMetrics").build();
    private static final MarshallingInfo<List> ADDITIONALSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalStatistics").build();
    private static final MetricStreamStatisticsConfigurationMarshaller instance = new MetricStreamStatisticsConfigurationMarshaller();

    public static MetricStreamStatisticsConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricStreamStatisticsConfiguration metricStreamStatisticsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (metricStreamStatisticsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            if (metricStreamStatisticsConfiguration.getIncludeMetrics() != null && !metricStreamStatisticsConfiguration.getIncludeMetrics().isEmpty()) {
                protocolMarshaller.marshall(metricStreamStatisticsConfiguration.getIncludeMetrics(), INCLUDEMETRICS_BINDING);
            }
            if (metricStreamStatisticsConfiguration.getAdditionalStatistics() != null && !metricStreamStatisticsConfiguration.getAdditionalStatistics().isEmpty()) {
                protocolMarshaller.marshall(metricStreamStatisticsConfiguration.getAdditionalStatistics(), ADDITIONALSTATISTICS_BINDING);
            }
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

