/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.ManagedRule;
import java.util.List;

@SdkInternalApi
public class ManagedRuleMarshaller {
    private static final MarshallingInfo<String> TEMPLATENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemplateName").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ManagedRuleMarshaller instance = new ManagedRuleMarshaller();

    public static ManagedRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(ManagedRule managedRule, ProtocolMarshaller protocolMarshaller) {
        if (managedRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)managedRule.getTemplateName(), TEMPLATENAME_BINDING);
            protocolMarshaller.marshall((Object)managedRule.getResourceARN(), RESOURCEARN_BINDING);
            if (managedRule.getTags() != null && !managedRule.getTags().isEmpty()) {
                protocolMarshaller.marshall(managedRule.getTags(), TAGS_BINDING);
            }
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

