/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatch.model.DashboardValidationMessage;

@SdkInternalApi
public class DashboardValidationMessageMarshaller {
    private static final MarshallingInfo<String> DATAPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataPath").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final DashboardValidationMessageMarshaller instance = new DashboardValidationMessageMarshaller();

    public static DashboardValidationMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(DashboardValidationMessage dashboardValidationMessage, ProtocolMarshaller protocolMarshaller) {
        if (dashboardValidationMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dashboardValidationMessage.getDataPath(), DATAPATH_BINDING);
            protocolMarshaller.marshall((Object)dashboardValidationMessage.getMessage(), MESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

