/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Query;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListQueriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Query> queries;
    private String nextToken;

    public List<Query> getQueries() {
        if (this.queries == null) {
            this.queries = new SdkInternalList();
        }
        return this.queries;
    }

    public void setQueries(Collection<Query> queries) {
        if (queries == null) {
            this.queries = null;
            return;
        }
        this.queries = new SdkInternalList(queries);
    }

    public ListQueriesResult withQueries(Query ... queries) {
        if (this.queries == null) {
            this.setQueries((Collection<Query>)new SdkInternalList(queries.length));
        }
        for (Query ele : queries) {
            this.queries.add((Object)ele);
        }
        return this;
    }

    public ListQueriesResult withQueries(Collection<Query> queries) {
        this.setQueries(queries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListQueriesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueries() != null) {
            sb.append("Queries: ").append(this.getQueries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueriesResult)) {
            return false;
        }
        ListQueriesResult other = (ListQueriesResult)obj;
        if (other.getQueries() == null ^ this.getQueries() == null) {
            return false;
        }
        if (other.getQueries() != null && !other.getQueries().equals(this.getQueries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueries() == null ? 0 : this.getQueries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListQueriesResult clone() {
        try {
            return (ListQueriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

