/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.services.cloudtrail.model.S3ImportSource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3ImportSourceJsonUnmarshaller
implements Unmarshaller<S3ImportSource, JsonUnmarshallerContext> {
    private static S3ImportSourceJsonUnmarshaller instance;

    public S3ImportSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3ImportSource s3ImportSource = new S3ImportSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3LocationUri", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3ImportSource.setS3LocationUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3BucketRegion", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3ImportSource.setS3BucketRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3BucketAccessRoleArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    s3ImportSource.setS3BucketAccessRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3ImportSource;
    }

    public static S3ImportSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ImportSourceJsonUnmarshaller();
        }
        return instance;
    }
}

