/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.PublicKey;
import java.nio.ByteBuffer;
import java.util.Date;

@SdkInternalApi
public class PublicKeyMarshaller {
    private static final MarshallingInfo<ByteBuffer> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Date> VALIDITYSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidityStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> VALIDITYENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidityEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FINGERPRINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Fingerprint").build();
    private static final PublicKeyMarshaller instance = new PublicKeyMarshaller();

    public static PublicKeyMarshaller getInstance() {
        return instance;
    }

    public void marshall(PublicKey publicKey, ProtocolMarshaller protocolMarshaller) {
        if (publicKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)publicKey.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)publicKey.getValidityStartTime(), VALIDITYSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)publicKey.getValidityEndTime(), VALIDITYENDTIME_BINDING);
            protocolMarshaller.marshall((Object)publicKey.getFingerprint(), FINGERPRINT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

