/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeTrailsRequestMarshaller
implements Marshaller<Request<DescribeTrailsRequest>, DescribeTrailsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeTrailsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeTrailsRequest> marshall(DescribeTrailsRequest describeTrailsRequest) {
        if (describeTrailsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrailsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.DescribeTrails");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList trailNameListList = (SdkInternalList)describeTrailsRequest.getTrailNameList();
            if (!trailNameListList.isEmpty() || !trailNameListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("trailNameList");
                jsonGenerator.writeStartArray();
                for (String trailNameListListValue : trailNameListList) {
                    if (trailNameListListValue == null) continue;
                    jsonGenerator.writeValue(trailNameListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeTrailsRequest.getIncludeShadowTrails() != null) {
                jsonGenerator.writeFieldName("includeShadowTrails").writeValue(describeTrailsRequest.getIncludeShadowTrails().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

