/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.Event;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class LookupEventsResult
implements Serializable,
Cloneable {
    private SdkInternalList<Event> events;
    private String nextToken;

    public List<Event> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<Event> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList(events);
    }

    public LookupEventsResult withEvents(Event ... events) {
        if (this.events == null) {
            this.setEvents((Collection<Event>)new SdkInternalList(events.length));
        }
        for (Event ele : events) {
            this.events.add((Object)ele);
        }
        return this;
    }

    public LookupEventsResult withEvents(Collection<Event> events) {
        this.setEvents(events);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public LookupEventsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupEventsResult)) {
            return false;
        }
        LookupEventsResult other = (LookupEventsResult)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public LookupEventsResult clone() {
        try {
            return (LookupEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

