/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudtrail.model.LookupAttribute;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.transform.LookupAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class LookupEventsRequestMarshaller
implements Marshaller<Request<LookupEventsRequest>, LookupEventsRequest> {
    public Request<LookupEventsRequest> marshall(LookupEventsRequest lookupEventsRequest) {
        if (lookupEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)lookupEventsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.LookupEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList lookupAttributesList = (SdkInternalList)lookupEventsRequest.getLookupAttributes();
            if (!lookupAttributesList.isEmpty() || !lookupAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LookupAttributes");
                jsonGenerator.writeStartArray();
                for (LookupAttribute lookupAttributesListValue : lookupAttributesList) {
                    if (lookupAttributesListValue == null) continue;
                    LookupAttributeJsonMarshaller.getInstance().marshall(lookupAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (lookupEventsRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(lookupEventsRequest.getStartTime());
            }
            if (lookupEventsRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(lookupEventsRequest.getEndTime());
            }
            if (lookupEventsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue((long)lookupEventsRequest.getMaxResults().intValue());
            }
            if (lookupEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(lookupEventsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

