/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudhsmv2.AWSCloudHSMV2;
import com.amazonaws.services.cloudhsmv2.AWSCloudHSMV2ClientBuilder;
import com.amazonaws.services.cloudhsmv2.model.AWSCloudHSMV2Exception;
import com.amazonaws.services.cloudhsmv2.model.CopyBackupToRegionRequest;
import com.amazonaws.services.cloudhsmv2.model.CopyBackupToRegionResult;
import com.amazonaws.services.cloudhsmv2.model.CreateClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.CreateClusterResult;
import com.amazonaws.services.cloudhsmv2.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsmv2.model.CreateHsmResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteBackupRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteBackupResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteClusterResult;
import com.amazonaws.services.cloudhsmv2.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsmv2.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsmv2.model.DescribeBackupsRequest;
import com.amazonaws.services.cloudhsmv2.model.DescribeBackupsResult;
import com.amazonaws.services.cloudhsmv2.model.DescribeClustersRequest;
import com.amazonaws.services.cloudhsmv2.model.DescribeClustersResult;
import com.amazonaws.services.cloudhsmv2.model.InitializeClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.InitializeClusterResult;
import com.amazonaws.services.cloudhsmv2.model.ListTagsRequest;
import com.amazonaws.services.cloudhsmv2.model.ListTagsResult;
import com.amazonaws.services.cloudhsmv2.model.ModifyBackupAttributesRequest;
import com.amazonaws.services.cloudhsmv2.model.ModifyBackupAttributesResult;
import com.amazonaws.services.cloudhsmv2.model.ModifyClusterRequest;
import com.amazonaws.services.cloudhsmv2.model.ModifyClusterResult;
import com.amazonaws.services.cloudhsmv2.model.RestoreBackupRequest;
import com.amazonaws.services.cloudhsmv2.model.RestoreBackupResult;
import com.amazonaws.services.cloudhsmv2.model.TagResourceRequest;
import com.amazonaws.services.cloudhsmv2.model.TagResourceResult;
import com.amazonaws.services.cloudhsmv2.model.UntagResourceRequest;
import com.amazonaws.services.cloudhsmv2.model.UntagResourceResult;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmAccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmInternalFailureExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmInvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmServiceExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CloudHsmTagExceptionUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CopyBackupToRegionRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CopyBackupToRegionResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CreateClusterRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CreateHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.CreateHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteBackupRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteBackupResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteClusterRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteHsmRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DeleteHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DescribeBackupsRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DescribeBackupsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DescribeClustersRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.DescribeClustersResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.InitializeClusterRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.InitializeClusterResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ListTagsRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ModifyBackupAttributesRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ModifyBackupAttributesResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ModifyClusterRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.ModifyClusterResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.RestoreBackupRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.RestoreBackupResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudHSMV2Client
extends AmazonWebServiceClient
implements AWSCloudHSMV2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudHSMV2.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudhsm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmInternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmTagException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmTagExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmServiceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmAccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmAccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CloudHsmInvalidRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCloudHSMV2Exception.class));

    public static AWSCloudHSMV2ClientBuilder builder() {
        return AWSCloudHSMV2ClientBuilder.standard();
    }

    AWSCloudHSMV2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCloudHSMV2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("cloudhsmv2");
        this.setEndpoint("cloudhsmv2.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudhsmv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudhsmv2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CopyBackupToRegionResult copyBackupToRegion(CopyBackupToRegionRequest request) {
        request = (CopyBackupToRegionRequest)this.beforeClientExecution(request);
        return this.executeCopyBackupToRegion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CopyBackupToRegionResult executeCopyBackupToRegion(CopyBackupToRegionRequest copyBackupToRegionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(copyBackupToRegionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CopyBackupToRegionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CopyBackupToRegionRequestProtocolMarshaller(protocolFactory).marshall((CopyBackupToRegionRequest)super.beforeMarshalling((AmazonWebServiceRequest)copyBackupToRegionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CopyBackupToRegion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CopyBackupToRegionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CopyBackupToRegionResult copyBackupToRegionResult = (CopyBackupToRegionResult)response.getAwsResponse();
            return copyBackupToRegionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateClusterResult createCluster(CreateClusterRequest request) {
        request = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executeCreateCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateClusterResult executeCreateCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestProtocolMarshaller(protocolFactory).marshall((CreateClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateHsmResult createHsm(CreateHsmRequest request) {
        request = (CreateHsmRequest)this.beforeClientExecution(request);
        return this.executeCreateHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateHsmResult executeCreateHsm(CreateHsmRequest createHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHsmRequestProtocolMarshaller(protocolFactory).marshall((CreateHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateHsmResult createHsmResult = (CreateHsmResult)response.getAwsResponse();
            return createHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackupResult deleteBackup(DeleteBackupRequest request) {
        request = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executeDeleteBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackupResult executeDeleteBackup(DeleteBackupRequest deleteBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupRequestProtocolMarshaller(protocolFactory).marshall((DeleteBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBackup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupResult deleteBackupResult = (DeleteBackupResult)response.getAwsResponse();
            return deleteBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest request) {
        request = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executeDeleteCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteClusterResult executeDeleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestProtocolMarshaller(protocolFactory).marshall((DeleteClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteHsmResult deleteHsm(DeleteHsmRequest request) {
        request = (DeleteHsmRequest)this.beforeClientExecution(request);
        return this.executeDeleteHsm(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHsmResult executeDeleteHsm(DeleteHsmRequest deleteHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHsmRequestProtocolMarshaller(protocolFactory).marshall((DeleteHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHsm");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHsmResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHsmResult deleteHsmResult = (DeleteHsmResult)response.getAwsResponse();
            return deleteHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeBackupsResult describeBackups(DescribeBackupsRequest request) {
        request = (DescribeBackupsRequest)this.beforeClientExecution(request);
        return this.executeDescribeBackups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeBackupsResult executeDescribeBackups(DescribeBackupsRequest describeBackupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupsRequestProtocolMarshaller(protocolFactory).marshall((DescribeBackupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBackupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeBackups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBackupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupsResult describeBackupsResult = (DescribeBackupsResult)response.getAwsResponse();
            return describeBackupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest request) {
        request = (DescribeClustersRequest)this.beforeClientExecution(request);
        return this.executeDescribeClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeClustersResult executeDescribeClusters(DescribeClustersRequest describeClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClustersRequestProtocolMarshaller(protocolFactory).marshall((DescribeClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClustersResult describeClustersResult = (DescribeClustersResult)response.getAwsResponse();
            return describeClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitializeClusterResult initializeCluster(InitializeClusterRequest request) {
        request = (InitializeClusterRequest)this.beforeClientExecution(request);
        return this.executeInitializeCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitializeClusterResult executeInitializeCluster(InitializeClusterRequest initializeClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initializeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitializeClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitializeClusterRequestProtocolMarshaller(protocolFactory).marshall((InitializeClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)initializeClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InitializeCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitializeClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitializeClusterResult initializeClusterResult = (InitializeClusterResult)response.getAwsResponse();
            return initializeClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsResult listTags(ListTagsRequest request) {
        request = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executeListTags(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsResult executeListTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestProtocolMarshaller(protocolFactory).marshall((ListTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTags");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyBackupAttributesResult modifyBackupAttributes(ModifyBackupAttributesRequest request) {
        request = (ModifyBackupAttributesRequest)this.beforeClientExecution(request);
        return this.executeModifyBackupAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyBackupAttributesResult executeModifyBackupAttributes(ModifyBackupAttributesRequest modifyBackupAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyBackupAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyBackupAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyBackupAttributesRequestProtocolMarshaller(protocolFactory).marshall((ModifyBackupAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyBackupAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ModifyBackupAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyBackupAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyBackupAttributesResult modifyBackupAttributesResult = (ModifyBackupAttributesResult)response.getAwsResponse();
            return modifyBackupAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ModifyClusterResult modifyCluster(ModifyClusterRequest request) {
        request = (ModifyClusterRequest)this.beforeClientExecution(request);
        return this.executeModifyCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ModifyClusterResult executeModifyCluster(ModifyClusterRequest modifyClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyClusterRequestProtocolMarshaller(protocolFactory).marshall((ModifyClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ModifyCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ModifyClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ModifyClusterResult modifyClusterResult = (ModifyClusterResult)response.getAwsResponse();
            return modifyClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RestoreBackupResult restoreBackup(RestoreBackupRequest request) {
        request = (RestoreBackupRequest)this.beforeClientExecution(request);
        return this.executeRestoreBackup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RestoreBackupResult executeRestoreBackup(RestoreBackupRequest restoreBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreBackupRequestProtocolMarshaller(protocolFactory).marshall((RestoreBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)restoreBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RestoreBackup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RestoreBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreBackupResult restoreBackupResult = (RestoreBackupResult)response.getAwsResponse();
            return restoreBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CloudHSM V2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

