/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class GetConfigRequestMarshaller
implements Marshaller<Request<GetConfigRequest>, GetConfigRequest> {
    public Request<GetConfigRequest> marshall(GetConfigRequest getConfigRequest) {
        if (getConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getConfigRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.GetConfig");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList hapgListList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (getConfigRequest.getClientArn() != null) {
                jsonWriter.key("ClientArn").value((Object)getConfigRequest.getClientArn());
            }
            if (getConfigRequest.getClientVersion() != null) {
                jsonWriter.key("ClientVersion").value((Object)getConfigRequest.getClientVersion());
            }
            if (!(hapgListList = (SdkInternalList)getConfigRequest.getHapgList()).isEmpty() || !hapgListList.isAutoConstruct()) {
                jsonWriter.key("HapgList");
                jsonWriter.array();
                for (String hapgListListValue : hapgListList) {
                    if (hapgListListValue == null) continue;
                    jsonWriter.value((Object)hapgListListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

