/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ModifyHsmRequestMarshaller
implements Marshaller<Request<ModifyHsmRequest>, ModifyHsmRequest> {
    public Request<ModifyHsmRequest> marshall(ModifyHsmRequest modifyHsmRequest) {
        if (modifyHsmRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyHsmRequest, "AWSCloudHSM");
        request.addHeader("X-Amz-Target", "CloudHsmFrontendService.ModifyHsm");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (modifyHsmRequest.getHsmArn() != null) {
                jsonWriter.key("HsmArn").value((Object)modifyHsmRequest.getHsmArn());
            }
            if (modifyHsmRequest.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)modifyHsmRequest.getSubnetId());
            }
            if (modifyHsmRequest.getEniIp() != null) {
                jsonWriter.key("EniIp").value((Object)modifyHsmRequest.getEniIp());
            }
            if (modifyHsmRequest.getIamRoleArn() != null) {
                jsonWriter.key("IamRoleArn").value((Object)modifyHsmRequest.getIamRoleArn());
            }
            if (modifyHsmRequest.getExternalId() != null) {
                jsonWriter.key("ExternalId").value((Object)modifyHsmRequest.getExternalId());
            }
            if (modifyHsmRequest.getSyslogIp() != null) {
                jsonWriter.key("SyslogIp").value((Object)modifyHsmRequest.getSyslogIp());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

