/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteDistributionRequestMarshaller
implements Marshaller<Request<DeleteDistributionRequest>, DeleteDistributionRequest> {
    public Request<DeleteDistributionRequest> marshall(DeleteDistributionRequest deleteDistributionRequest) {
        if (deleteDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)deleteDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "2014-11-06/distribution/{Id}";
        if ((uriResourcePath = uriResourcePath.replace("{Id}", this.getString(deleteDistributionRequest.getId()))).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

