/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.PublishFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class PublishFunctionRequestMarshaller
implements Marshaller<Request<PublishFunctionRequest>, PublishFunctionRequest> {
    public Request<PublishFunctionRequest> marshall(PublishFunctionRequest publishFunctionRequest) {
        if (publishFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishFunctionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)publishFunctionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2020-05-31/function/{Name}/publish";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", publishFunctionRequest.getName());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

