/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.KeyGroupConfig;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class KeyGroupConfigStaxUnmarshaller
implements Unmarshaller<KeyGroupConfig, StaxUnmarshallerContext> {
    private static KeyGroupConfigStaxUnmarshaller instance;

    public KeyGroupConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyGroupConfig keyGroupConfig = new KeyGroupConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyGroupConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    keyGroupConfig.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    keyGroupConfig.withItems(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Items/PublicKey", targetDepth)) {
                    keyGroupConfig.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Comment", targetDepth)) continue;
                keyGroupConfig.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyGroupConfig;
    }

    public static KeyGroupConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyGroupConfigStaxUnmarshaller();
        }
        return instance;
    }
}

