/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.CookieNames;
import com.amazonaws.services.cloudfront.model.CookiePreference;
import com.amazonaws.services.cloudfront.model.CustomErrorResponse;
import com.amazonaws.services.cloudfront.model.CustomErrorResponses;
import com.amazonaws.services.cloudfront.model.CustomHeaders;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.GeoRestriction;
import com.amazonaws.services.cloudfront.model.Headers;
import com.amazonaws.services.cloudfront.model.LambdaFunctionAssociation;
import com.amazonaws.services.cloudfront.model.LambdaFunctionAssociations;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.OriginCustomHeader;
import com.amazonaws.services.cloudfront.model.OriginGroup;
import com.amazonaws.services.cloudfront.model.OriginGroupFailoverCriteria;
import com.amazonaws.services.cloudfront.model.OriginGroupMember;
import com.amazonaws.services.cloudfront.model.OriginGroupMembers;
import com.amazonaws.services.cloudfront.model.OriginGroups;
import com.amazonaws.services.cloudfront.model.OriginSslProtocols;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.QueryStringCacheKeys;
import com.amazonaws.services.cloudfront.model.Restrictions;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.StatusCodes;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.services.cloudfront.model.ViewerCertificate;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public class UpdateDistributionRequestMarshaller
implements Marshaller<Request<UpdateDistributionRequest>, UpdateDistributionRequest> {
    public Request<UpdateDistributionRequest> marshall(UpdateDistributionRequest updateDistributionRequest) {
        if (updateDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString((String)updateDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2019-03-26/distribution/{Id}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", updateDistributionRequest.getId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2019-03-26/");
            DistributionConfig distributionConfig = updateDistributionRequest.getDistributionConfig();
            if (distributionConfig != null) {
                Restrictions restrictions;
                ViewerCertificate viewerCertificate;
                LoggingConfig logging;
                CustomErrorResponses customErrorResponses;
                CacheBehaviors cacheBehaviors;
                DefaultCacheBehavior defaultCacheBehavior;
                OriginGroups originGroups;
                Iterator originSslProtocolsItemsList;
                Origins origins;
                Aliases aliases;
                xmlWriter.startElement("DistributionConfig");
                if (distributionConfig.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(distributionConfig.getCallerReference()).endElement();
                }
                if ((aliases = distributionConfig.getAliases()) != null) {
                    SdkInternalList aliasesItemsList;
                    xmlWriter.startElement("Aliases");
                    if (aliases.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)aliases.getQuantity()).endElement();
                    }
                    if (!(aliasesItemsList = (SdkInternalList)aliases.getItems()).isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Object aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value((String)aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getDefaultRootObject() != null) {
                    xmlWriter.startElement("DefaultRootObject").value(distributionConfig.getDefaultRootObject()).endElement();
                }
                if ((origins = distributionConfig.getOrigins()) != null) {
                    SdkInternalList originsItemsList;
                    xmlWriter.startElement("Origins");
                    if (origins.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)origins.getQuantity()).endElement();
                    }
                    if (!(originsItemsList = (SdkInternalList)origins.getItems()).isEmpty() || !originsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Object originsItemsListValue : originsItemsList) {
                            CustomOriginConfig customOriginConfig;
                            S3OriginConfig s3OriginConfig;
                            CustomHeaders customHeaders;
                            xmlWriter.startElement("Origin");
                            if (((Origin)originsItemsListValue).getId() != null) {
                                xmlWriter.startElement("Id").value(((Origin)originsItemsListValue).getId()).endElement();
                            }
                            if (((Origin)originsItemsListValue).getDomainName() != null) {
                                xmlWriter.startElement("DomainName").value(((Origin)originsItemsListValue).getDomainName()).endElement();
                            }
                            if (((Origin)originsItemsListValue).getOriginPath() != null) {
                                xmlWriter.startElement("OriginPath").value(((Origin)originsItemsListValue).getOriginPath()).endElement();
                            }
                            if ((customHeaders = ((Origin)originsItemsListValue).getCustomHeaders()) != null) {
                                SdkInternalList customHeadersItemsList;
                                xmlWriter.startElement("CustomHeaders");
                                if (customHeaders.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)customHeaders.getQuantity()).endElement();
                                }
                                if (!(customHeadersItemsList = (SdkInternalList)customHeaders.getItems()).isEmpty() || !customHeadersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (OriginCustomHeader customHeadersItemsListValue : customHeadersItemsList) {
                                        xmlWriter.startElement("OriginCustomHeader");
                                        if (customHeadersItemsListValue.getHeaderName() != null) {
                                            xmlWriter.startElement("HeaderName").value(customHeadersItemsListValue.getHeaderName()).endElement();
                                        }
                                        if (customHeadersItemsListValue.getHeaderValue() != null) {
                                            xmlWriter.startElement("HeaderValue").value(customHeadersItemsListValue.getHeaderValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((s3OriginConfig = ((Origin)originsItemsListValue).getS3OriginConfig()) != null) {
                                xmlWriter.startElement("S3OriginConfig");
                                if (s3OriginConfig.getOriginAccessIdentity() != null) {
                                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.getOriginAccessIdentity()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((customOriginConfig = ((Origin)originsItemsListValue).getCustomOriginConfig()) != null) {
                                OriginSslProtocols originSslProtocols;
                                xmlWriter.startElement("CustomOriginConfig");
                                if (customOriginConfig.getHTTPPort() != null) {
                                    xmlWriter.startElement("HTTPPort").value((Object)customOriginConfig.getHTTPPort()).endElement();
                                }
                                if (customOriginConfig.getHTTPSPort() != null) {
                                    xmlWriter.startElement("HTTPSPort").value((Object)customOriginConfig.getHTTPSPort()).endElement();
                                }
                                if (customOriginConfig.getOriginProtocolPolicy() != null) {
                                    xmlWriter.startElement("OriginProtocolPolicy").value(customOriginConfig.getOriginProtocolPolicy()).endElement();
                                }
                                if ((originSslProtocols = customOriginConfig.getOriginSslProtocols()) != null) {
                                    xmlWriter.startElement("OriginSslProtocols");
                                    if (originSslProtocols.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)originSslProtocols.getQuantity()).endElement();
                                    }
                                    if (!(originSslProtocolsItemsList = (SdkInternalList)originSslProtocols.getItems()).isEmpty() || !originSslProtocolsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        Iterator iterator = originSslProtocolsItemsList.iterator();
                                        while (iterator.hasNext()) {
                                            String originSslProtocolsItemsListValue = (String)iterator.next();
                                            xmlWriter.startElement("SslProtocol");
                                            xmlWriter.value(originSslProtocolsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (customOriginConfig.getOriginReadTimeout() != null) {
                                    xmlWriter.startElement("OriginReadTimeout").value((Object)customOriginConfig.getOriginReadTimeout()).endElement();
                                }
                                if (customOriginConfig.getOriginKeepaliveTimeout() != null) {
                                    xmlWriter.startElement("OriginKeepaliveTimeout").value((Object)customOriginConfig.getOriginKeepaliveTimeout()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((originGroups = distributionConfig.getOriginGroups()) != null) {
                    SdkInternalList originGroupsItemsList;
                    xmlWriter.startElement("OriginGroups");
                    if (originGroups.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)originGroups.getQuantity()).endElement();
                    }
                    if (!(originGroupsItemsList = (SdkInternalList)originGroups.getItems()).isEmpty() || !originGroupsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (OriginGroup originGroupsItemsListValue : originGroupsItemsList) {
                            OriginGroupMembers members;
                            OriginGroupFailoverCriteria failoverCriteria;
                            xmlWriter.startElement("OriginGroup");
                            if (originGroupsItemsListValue.getId() != null) {
                                xmlWriter.startElement("Id").value(originGroupsItemsListValue.getId()).endElement();
                            }
                            if ((failoverCriteria = originGroupsItemsListValue.getFailoverCriteria()) != null) {
                                xmlWriter.startElement("FailoverCriteria");
                                StatusCodes statusCodes = failoverCriteria.getStatusCodes();
                                if (statusCodes != null) {
                                    SdkInternalList statusCodesItemsList;
                                    xmlWriter.startElement("StatusCodes");
                                    if (statusCodes.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)statusCodes.getQuantity()).endElement();
                                    }
                                    if (!(statusCodesItemsList = (SdkInternalList)statusCodes.getItems()).isEmpty() || !statusCodesItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (Integer statusCodesItemsListValue : statusCodesItemsList) {
                                            xmlWriter.startElement("StatusCode");
                                            xmlWriter.value((Object)statusCodesItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((members = originGroupsItemsListValue.getMembers()) != null) {
                                Iterator originGroupMembersItemsList;
                                xmlWriter.startElement("Members");
                                if (members.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)members.getQuantity()).endElement();
                                }
                                if (!(originGroupMembersItemsList = (SdkInternalList)members.getItems()).isEmpty() || !originGroupMembersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    originSslProtocolsItemsList = originGroupMembersItemsList.iterator();
                                    while (originSslProtocolsItemsList.hasNext()) {
                                        OriginGroupMember originGroupMembersItemsListValue = (OriginGroupMember)originSslProtocolsItemsList.next();
                                        xmlWriter.startElement("OriginGroupMember");
                                        if (originGroupMembersItemsListValue.getOriginId() != null) {
                                            xmlWriter.startElement("OriginId").value(originGroupMembersItemsListValue.getOriginId()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((defaultCacheBehavior = distributionConfig.getDefaultCacheBehavior()) != null) {
                    LambdaFunctionAssociations lambdaFunctionAssociations;
                    Object allowedMethods;
                    TrustedSigners trustedSigners;
                    ForwardedValues forwardedValues;
                    xmlWriter.startElement("DefaultCacheBehavior");
                    if (defaultCacheBehavior.getTargetOriginId() != null) {
                        xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.getTargetOriginId()).endElement();
                    }
                    if ((forwardedValues = defaultCacheBehavior.getForwardedValues()) != null) {
                        Object queryStringCacheKeys;
                        Headers headers;
                        CookiePreference cookies;
                        xmlWriter.startElement("ForwardedValues");
                        if (forwardedValues.getQueryString() != null) {
                            xmlWriter.startElement("QueryString").value((Object)forwardedValues.getQueryString()).endElement();
                        }
                        if ((cookies = forwardedValues.getCookies()) != null) {
                            CookieNames whitelistedNames;
                            xmlWriter.startElement("Cookies");
                            if (cookies.getForward() != null) {
                                xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                            }
                            if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                SdkInternalList cookieNamesItemsList;
                                xmlWriter.startElement("WhitelistedNames");
                                if (whitelistedNames.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)whitelistedNames.getQuantity()).endElement();
                                }
                                if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value(cookieNamesItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((headers = forwardedValues.getHeaders()) != null) {
                            SdkInternalList headersItemsList;
                            xmlWriter.startElement("Headers");
                            if (headers.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)headers.getQuantity()).endElement();
                            }
                            if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (Object headersItemsListValue : headersItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value((String)headersItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                            SdkInternalList queryStringCacheKeysItemsList;
                            xmlWriter.startElement("QueryStringCacheKeys");
                            if (((QueryStringCacheKeys)queryStringCacheKeys).getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)((QueryStringCacheKeys)queryStringCacheKeys).getQuantity()).endElement();
                            }
                            if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (Object queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                    xmlWriter.startElement("Name");
                                    xmlWriter.value((String)queryStringCacheKeysItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((trustedSigners = defaultCacheBehavior.getTrustedSigners()) != null) {
                        SdkInternalList trustedSignersItemsList;
                        xmlWriter.startElement("TrustedSigners");
                        if (trustedSigners.getEnabled() != null) {
                            xmlWriter.startElement("Enabled").value((Object)trustedSigners.getEnabled()).endElement();
                        }
                        if (trustedSigners.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)trustedSigners.getQuantity()).endElement();
                        }
                        if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (Object trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value((String)trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getViewerProtocolPolicy() != null) {
                        xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.getViewerProtocolPolicy()).endElement();
                    }
                    if (defaultCacheBehavior.getMinTTL() != null) {
                        xmlWriter.startElement("MinTTL").value((Object)defaultCacheBehavior.getMinTTL()).endElement();
                    }
                    if ((allowedMethods = defaultCacheBehavior.getAllowedMethods()) != null) {
                        CachedMethods cachedMethods;
                        SdkInternalList allowedMethodsItemsList;
                        xmlWriter.startElement("AllowedMethods");
                        if (((AllowedMethods)allowedMethods).getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)((AllowedMethods)allowedMethods).getQuantity()).endElement();
                        }
                        if (!(allowedMethodsItemsList = (SdkInternalList)((AllowedMethods)allowedMethods).getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                xmlWriter.startElement("Method");
                                xmlWriter.value(allowedMethodsItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((cachedMethods = ((AllowedMethods)allowedMethods).getCachedMethods()) != null) {
                            Object cachedMethodsItemsList;
                            xmlWriter.startElement("CachedMethods");
                            if (cachedMethods.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)cachedMethods.getQuantity()).endElement();
                            }
                            if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                Object queryStringCacheKeysItemsListValue;
                                xmlWriter.startElement("Items");
                                queryStringCacheKeysItemsListValue = cachedMethodsItemsList.iterator();
                                while (queryStringCacheKeysItemsListValue.hasNext()) {
                                    String cachedMethodsItemsListValue = (String)queryStringCacheKeysItemsListValue.next();
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(cachedMethodsItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getSmoothStreaming() != null) {
                        xmlWriter.startElement("SmoothStreaming").value((Object)defaultCacheBehavior.getSmoothStreaming()).endElement();
                    }
                    if (defaultCacheBehavior.getDefaultTTL() != null) {
                        xmlWriter.startElement("DefaultTTL").value((Object)defaultCacheBehavior.getDefaultTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getMaxTTL() != null) {
                        xmlWriter.startElement("MaxTTL").value((Object)defaultCacheBehavior.getMaxTTL()).endElement();
                    }
                    if (defaultCacheBehavior.getCompress() != null) {
                        xmlWriter.startElement("Compress").value((Object)defaultCacheBehavior.getCompress()).endElement();
                    }
                    if ((lambdaFunctionAssociations = defaultCacheBehavior.getLambdaFunctionAssociations()) != null) {
                        SdkInternalList lambdaFunctionAssociationsItemsList;
                        xmlWriter.startElement("LambdaFunctionAssociations");
                        if (lambdaFunctionAssociations.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.getQuantity()).endElement();
                        }
                        if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.getItems()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                xmlWriter.startElement("LambdaFunctionAssociation");
                                if (lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN() != null) {
                                    xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN()).endElement();
                                }
                                if (lambdaFunctionAssociationsItemsListValue.getEventType() != null) {
                                    xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.getEventType()).endElement();
                                }
                                if (lambdaFunctionAssociationsItemsListValue.getIncludeBody() != null) {
                                    xmlWriter.startElement("IncludeBody").value((Object)lambdaFunctionAssociationsItemsListValue.getIncludeBody()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (defaultCacheBehavior.getFieldLevelEncryptionId() != null) {
                        xmlWriter.startElement("FieldLevelEncryptionId").value(defaultCacheBehavior.getFieldLevelEncryptionId()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((cacheBehaviors = distributionConfig.getCacheBehaviors()) != null) {
                    SdkInternalList cacheBehaviorsItemsList;
                    xmlWriter.startElement("CacheBehaviors");
                    if (cacheBehaviors.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)cacheBehaviors.getQuantity()).endElement();
                    }
                    if (!(cacheBehaviorsItemsList = (SdkInternalList)cacheBehaviors.getItems()).isEmpty() || !cacheBehaviorsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Object cacheBehaviorsItemsListValue : cacheBehaviorsItemsList) {
                            LambdaFunctionAssociations lambdaFunctionAssociations;
                            AllowedMethods allowedMethods;
                            TrustedSigners trustedSigners;
                            Object queryStringCacheKeys;
                            ForwardedValues forwardedValues;
                            xmlWriter.startElement("CacheBehavior");
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getPathPattern() != null) {
                                xmlWriter.startElement("PathPattern").value(((CacheBehavior)cacheBehaviorsItemsListValue).getPathPattern()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getTargetOriginId() != null) {
                                xmlWriter.startElement("TargetOriginId").value(((CacheBehavior)cacheBehaviorsItemsListValue).getTargetOriginId()).endElement();
                            }
                            if ((forwardedValues = ((CacheBehavior)cacheBehaviorsItemsListValue).getForwardedValues()) != null) {
                                Headers headers;
                                CookiePreference cookies;
                                xmlWriter.startElement("ForwardedValues");
                                if (forwardedValues.getQueryString() != null) {
                                    xmlWriter.startElement("QueryString").value((Object)forwardedValues.getQueryString()).endElement();
                                }
                                if ((cookies = forwardedValues.getCookies()) != null) {
                                    CookieNames whitelistedNames;
                                    xmlWriter.startElement("Cookies");
                                    if (cookies.getForward() != null) {
                                        xmlWriter.startElement("Forward").value(cookies.getForward()).endElement();
                                    }
                                    if ((whitelistedNames = cookies.getWhitelistedNames()) != null) {
                                        SdkInternalList cookieNamesItemsList;
                                        xmlWriter.startElement("WhitelistedNames");
                                        if (whitelistedNames.getQuantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)whitelistedNames.getQuantity()).endElement();
                                        }
                                        if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.getItems()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(cookieNamesItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((headers = forwardedValues.getHeaders()) != null) {
                                    SdkInternalList headersItemsList;
                                    xmlWriter.startElement("Headers");
                                    if (headers.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)headers.getQuantity()).endElement();
                                    }
                                    if (!(headersItemsList = (SdkInternalList)headers.getItems()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (Object headersItemsListValue : headersItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value((String)headersItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((queryStringCacheKeys = forwardedValues.getQueryStringCacheKeys()) != null) {
                                    SdkInternalList queryStringCacheKeysItemsList;
                                    xmlWriter.startElement("QueryStringCacheKeys");
                                    if (((QueryStringCacheKeys)queryStringCacheKeys).getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)((QueryStringCacheKeys)queryStringCacheKeys).getQuantity()).endElement();
                                    }
                                    if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).getItems()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                        Object headersItemsListValue;
                                        xmlWriter.startElement("Items");
                                        headersItemsListValue = queryStringCacheKeysItemsList.iterator();
                                        while (headersItemsListValue.hasNext()) {
                                            String queryStringCacheKeysItemsListValue = (String)headersItemsListValue.next();
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(queryStringCacheKeysItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((trustedSigners = ((CacheBehavior)cacheBehaviorsItemsListValue).getTrustedSigners()) != null) {
                                SdkInternalList trustedSignersItemsList;
                                xmlWriter.startElement("TrustedSigners");
                                if (trustedSigners.getEnabled() != null) {
                                    xmlWriter.startElement("Enabled").value((Object)trustedSigners.getEnabled()).endElement();
                                }
                                if (trustedSigners.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)trustedSigners.getQuantity()).endElement();
                                }
                                if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.getItems()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    queryStringCacheKeys = trustedSignersItemsList.iterator();
                                    while (queryStringCacheKeys.hasNext()) {
                                        String trustedSignersItemsListValue = (String)queryStringCacheKeys.next();
                                        xmlWriter.startElement("AwsAccountNumber");
                                        xmlWriter.value(trustedSignersItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getViewerProtocolPolicy() != null) {
                                xmlWriter.startElement("ViewerProtocolPolicy").value(((CacheBehavior)cacheBehaviorsItemsListValue).getViewerProtocolPolicy()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getMinTTL() != null) {
                                xmlWriter.startElement("MinTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).getMinTTL()).endElement();
                            }
                            if ((allowedMethods = ((CacheBehavior)cacheBehaviorsItemsListValue).getAllowedMethods()) != null) {
                                CachedMethods cachedMethods;
                                SdkInternalList allowedMethodsItemsList;
                                xmlWriter.startElement("AllowedMethods");
                                if (allowedMethods.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)allowedMethods.getQuantity()).endElement();
                                }
                                if (!(allowedMethodsItemsList = (SdkInternalList)allowedMethods.getItems()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(allowedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((cachedMethods = allowedMethods.getCachedMethods()) != null) {
                                    SdkInternalList cachedMethodsItemsList;
                                    xmlWriter.startElement("CachedMethods");
                                    if (cachedMethods.getQuantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)cachedMethods.getQuantity()).endElement();
                                    }
                                    if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.getItems()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(cachedMethodsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getSmoothStreaming() != null) {
                                xmlWriter.startElement("SmoothStreaming").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).getSmoothStreaming()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getDefaultTTL() != null) {
                                xmlWriter.startElement("DefaultTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).getDefaultTTL()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getMaxTTL() != null) {
                                xmlWriter.startElement("MaxTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).getMaxTTL()).endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getCompress() != null) {
                                xmlWriter.startElement("Compress").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).getCompress()).endElement();
                            }
                            if ((lambdaFunctionAssociations = ((CacheBehavior)cacheBehaviorsItemsListValue).getLambdaFunctionAssociations()) != null) {
                                SdkInternalList lambdaFunctionAssociationsItemsList;
                                xmlWriter.startElement("LambdaFunctionAssociations");
                                if (lambdaFunctionAssociations.getQuantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.getQuantity()).endElement();
                                }
                                if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.getItems()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                        xmlWriter.startElement("LambdaFunctionAssociation");
                                        if (lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN() != null) {
                                            xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.getLambdaFunctionARN()).endElement();
                                        }
                                        if (lambdaFunctionAssociationsItemsListValue.getEventType() != null) {
                                            xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.getEventType()).endElement();
                                        }
                                        if (lambdaFunctionAssociationsItemsListValue.getIncludeBody() != null) {
                                            xmlWriter.startElement("IncludeBody").value((Object)lambdaFunctionAssociationsItemsListValue.getIncludeBody()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (((CacheBehavior)cacheBehaviorsItemsListValue).getFieldLevelEncryptionId() != null) {
                                xmlWriter.startElement("FieldLevelEncryptionId").value(((CacheBehavior)cacheBehaviorsItemsListValue).getFieldLevelEncryptionId()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((customErrorResponses = distributionConfig.getCustomErrorResponses()) != null) {
                    SdkInternalList customErrorResponsesItemsList;
                    xmlWriter.startElement("CustomErrorResponses");
                    if (customErrorResponses.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)customErrorResponses.getQuantity()).endElement();
                    }
                    if (!(customErrorResponsesItemsList = (SdkInternalList)customErrorResponses.getItems()).isEmpty() || !customErrorResponsesItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (CustomErrorResponse customErrorResponsesItemsListValue : customErrorResponsesItemsList) {
                            xmlWriter.startElement("CustomErrorResponse");
                            if (customErrorResponsesItemsListValue.getErrorCode() != null) {
                                xmlWriter.startElement("ErrorCode").value((Object)customErrorResponsesItemsListValue.getErrorCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponsePagePath() != null) {
                                xmlWriter.startElement("ResponsePagePath").value(customErrorResponsesItemsListValue.getResponsePagePath()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getResponseCode() != null) {
                                xmlWriter.startElement("ResponseCode").value(customErrorResponsesItemsListValue.getResponseCode()).endElement();
                            }
                            if (customErrorResponsesItemsListValue.getErrorCachingMinTTL() != null) {
                                xmlWriter.startElement("ErrorCachingMinTTL").value((Object)customErrorResponsesItemsListValue.getErrorCachingMinTTL()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(distributionConfig.getComment()).endElement();
                }
                if ((logging = distributionConfig.getLogging()) != null) {
                    xmlWriter.startElement("Logging");
                    if (logging.getEnabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)logging.getEnabled()).endElement();
                    }
                    if (logging.getIncludeCookies() != null) {
                        xmlWriter.startElement("IncludeCookies").value((Object)logging.getIncludeCookies()).endElement();
                    }
                    if (logging.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.getBucket()).endElement();
                    }
                    if (logging.getPrefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.getPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getPriceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(distributionConfig.getPriceClass()).endElement();
                }
                if (distributionConfig.getEnabled() != null) {
                    xmlWriter.startElement("Enabled").value((Object)distributionConfig.getEnabled()).endElement();
                }
                if ((viewerCertificate = distributionConfig.getViewerCertificate()) != null) {
                    xmlWriter.startElement("ViewerCertificate");
                    if (viewerCertificate.getCloudFrontDefaultCertificate() != null) {
                        xmlWriter.startElement("CloudFrontDefaultCertificate").value((Object)viewerCertificate.getCloudFrontDefaultCertificate()).endElement();
                    }
                    if (viewerCertificate.getIAMCertificateId() != null) {
                        xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.getIAMCertificateId()).endElement();
                    }
                    if (viewerCertificate.getACMCertificateArn() != null) {
                        xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.getACMCertificateArn()).endElement();
                    }
                    if (viewerCertificate.getSSLSupportMethod() != null) {
                        xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.getSSLSupportMethod()).endElement();
                    }
                    if (viewerCertificate.getMinimumProtocolVersion() != null) {
                        xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.getMinimumProtocolVersion()).endElement();
                    }
                    if (viewerCertificate.getCertificate() != null) {
                        xmlWriter.startElement("Certificate").value(viewerCertificate.getCertificate()).endElement();
                    }
                    if (viewerCertificate.getCertificateSource() != null) {
                        xmlWriter.startElement("CertificateSource").value(viewerCertificate.getCertificateSource()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((restrictions = distributionConfig.getRestrictions()) != null) {
                    xmlWriter.startElement("Restrictions");
                    GeoRestriction geoRestriction = restrictions.getGeoRestriction();
                    if (geoRestriction != null) {
                        SdkInternalList geoRestrictionItemsList;
                        xmlWriter.startElement("GeoRestriction");
                        if (geoRestriction.getRestrictionType() != null) {
                            xmlWriter.startElement("RestrictionType").value(geoRestriction.getRestrictionType()).endElement();
                        }
                        if (geoRestriction.getQuantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)geoRestriction.getQuantity()).endElement();
                        }
                        if (!(geoRestrictionItemsList = (SdkInternalList)geoRestriction.getItems()).isEmpty() || !geoRestrictionItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (String geoRestrictionItemsListValue : geoRestrictionItemsList) {
                                xmlWriter.startElement("Location");
                                xmlWriter.value(geoRestrictionItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (distributionConfig.getWebACLId() != null) {
                    xmlWriter.startElement("WebACLId").value(distributionConfig.getWebACLId()).endElement();
                }
                if (distributionConfig.getHttpVersion() != null) {
                    xmlWriter.startElement("HttpVersion").value(distributionConfig.getHttpVersion()).endElement();
                }
                if (distributionConfig.getIsIPV6Enabled() != null) {
                    xmlWriter.startElement("IsIPV6Enabled").value((Object)distributionConfig.getIsIPV6Enabled()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

