/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.ActiveTrustedSigners;
import com.amazonaws.services.cloudfront.model.AliasICPRecordal;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Distribution
implements Serializable,
Cloneable {
    private String id;
    private String aRN;
    private String status;
    private Date lastModifiedTime;
    private Integer inProgressInvalidationBatches;
    private String domainName;
    private ActiveTrustedSigners activeTrustedSigners;
    private DistributionConfig distributionConfig;
    private SdkInternalList<AliasICPRecordal> aliasICPRecordals;

    public Distribution() {
    }

    public Distribution(String id, String status, String domainName) {
        this.setId(id);
        this.setStatus(status);
        this.setDomainName(domainName);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Distribution withId(String id) {
        this.setId(id);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public Distribution withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Distribution withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Distribution withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setInProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
        this.inProgressInvalidationBatches = inProgressInvalidationBatches;
    }

    public Integer getInProgressInvalidationBatches() {
        return this.inProgressInvalidationBatches;
    }

    public Distribution withInProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
        this.setInProgressInvalidationBatches(inProgressInvalidationBatches);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Distribution withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setActiveTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
        this.activeTrustedSigners = activeTrustedSigners;
    }

    public ActiveTrustedSigners getActiveTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public Distribution withActiveTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
        this.setActiveTrustedSigners(activeTrustedSigners);
        return this;
    }

    public void setDistributionConfig(DistributionConfig distributionConfig) {
        this.distributionConfig = distributionConfig;
    }

    public DistributionConfig getDistributionConfig() {
        return this.distributionConfig;
    }

    public Distribution withDistributionConfig(DistributionConfig distributionConfig) {
        this.setDistributionConfig(distributionConfig);
        return this;
    }

    public List<AliasICPRecordal> getAliasICPRecordals() {
        if (this.aliasICPRecordals == null) {
            this.aliasICPRecordals = new SdkInternalList();
        }
        return this.aliasICPRecordals;
    }

    public void setAliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
        if (aliasICPRecordals == null) {
            this.aliasICPRecordals = null;
            return;
        }
        this.aliasICPRecordals = new SdkInternalList(aliasICPRecordals);
    }

    public Distribution withAliasICPRecordals(AliasICPRecordal ... aliasICPRecordals) {
        if (this.aliasICPRecordals == null) {
            this.setAliasICPRecordals((Collection<AliasICPRecordal>)new SdkInternalList(aliasICPRecordals.length));
        }
        for (AliasICPRecordal ele : aliasICPRecordals) {
            this.aliasICPRecordals.add((Object)ele);
        }
        return this;
    }

    public Distribution withAliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
        this.setAliasICPRecordals(aliasICPRecordals);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getInProgressInvalidationBatches() != null) {
            sb.append("InProgressInvalidationBatches: ").append(this.getInProgressInvalidationBatches()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getActiveTrustedSigners() != null) {
            sb.append("ActiveTrustedSigners: ").append(this.getActiveTrustedSigners()).append(",");
        }
        if (this.getDistributionConfig() != null) {
            sb.append("DistributionConfig: ").append(this.getDistributionConfig()).append(",");
        }
        if (this.getAliasICPRecordals() != null) {
            sb.append("AliasICPRecordals: ").append(this.getAliasICPRecordals());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getInProgressInvalidationBatches() == null ^ this.getInProgressInvalidationBatches() == null) {
            return false;
        }
        if (other.getInProgressInvalidationBatches() != null && !other.getInProgressInvalidationBatches().equals(this.getInProgressInvalidationBatches())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getActiveTrustedSigners() == null ^ this.getActiveTrustedSigners() == null) {
            return false;
        }
        if (other.getActiveTrustedSigners() != null && !other.getActiveTrustedSigners().equals(this.getActiveTrustedSigners())) {
            return false;
        }
        if (other.getDistributionConfig() == null ^ this.getDistributionConfig() == null) {
            return false;
        }
        if (other.getDistributionConfig() != null && !other.getDistributionConfig().equals(this.getDistributionConfig())) {
            return false;
        }
        if (other.getAliasICPRecordals() == null ^ this.getAliasICPRecordals() == null) {
            return false;
        }
        return other.getAliasICPRecordals() == null || other.getAliasICPRecordals().equals(this.getAliasICPRecordals());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getInProgressInvalidationBatches() == null ? 0 : this.getInProgressInvalidationBatches().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getActiveTrustedSigners() == null ? 0 : this.getActiveTrustedSigners().hashCode());
        hashCode = 31 * hashCode + (this.getDistributionConfig() == null ? 0 : this.getDistributionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAliasICPRecordals() == null ? 0 : this.getAliasICPRecordals().hashCode());
        return hashCode;
    }

    public Distribution clone() {
        try {
            return (Distribution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

