/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.services.cloudfront.model.Paths;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateInvalidationRequestMarshaller
implements Marshaller<Request<CreateInvalidationRequest>, CreateInvalidationRequest> {
    public Request<CreateInvalidationRequest> marshall(CreateInvalidationRequest createInvalidationRequest) {
        if (createInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2016-09-07/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", createInvalidationRequest.getDistributionId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)createInvalidationRequest.getDistributionId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2016-09-07/");
            InvalidationBatch invalidationBatch = createInvalidationRequest.getInvalidationBatch();
            if (invalidationBatch != null) {
                xmlWriter.startElement("InvalidationBatch");
                Paths paths = invalidationBatch.getPaths();
                if (paths != null) {
                    SdkInternalList pathsItemsList;
                    xmlWriter.startElement("Paths");
                    if (paths.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)paths.getQuantity()).endElement();
                    }
                    if (!(pathsItemsList = (SdkInternalList)paths.getItems()).isEmpty() || !pathsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (String pathsItemsListValue : pathsItemsList) {
                            xmlWriter.startElement("Path");
                            xmlWriter.value(pathsItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (invalidationBatch.getCallerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(invalidationBatch.getCallerReference()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

