/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.PublicKey;
import com.amazonaws.services.cloudfront.model.transform.PublicKeyConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PublicKeyStaxUnmarshaller
implements Unmarshaller<PublicKey, StaxUnmarshallerContext> {
    private static PublicKeyStaxUnmarshaller instance;

    public PublicKey unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublicKey publicKey = new PublicKey();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return publicKey;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    publicKey.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    publicKey.setCreatedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PublicKeyConfig", targetDepth)) continue;
                publicKey.setPublicKeyConfig(PublicKeyConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publicKey;
    }

    public static PublicKeyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublicKeyStaxUnmarshaller();
        }
        return instance;
    }
}

