/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CachedMethodsStaxUnmarshaller
implements Unmarshaller<CachedMethods, StaxUnmarshallerContext> {
    private static CachedMethodsStaxUnmarshaller instance;

    public CachedMethods unmarshall(StaxUnmarshallerContext context) throws Exception {
        CachedMethods cachedMethods = new CachedMethods();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cachedMethods;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    cachedMethods.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/Method", targetDepth)) continue;
                cachedMethods.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cachedMethods;
    }

    public static CachedMethodsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CachedMethodsStaxUnmarshaller();
        }
        return instance;
    }
}

