/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.PEM;
import com.amazonaws.auth.RSA;
import com.amazonaws.util.Base64;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public enum CloudFrontUrlSigner {

    private static final SecureRandom srand = new SecureRandom();

    public static String getSignedURLWithCannedPolicy(Protocol protocol, String distributionDomain, File privateKeyFile, String s3ObjectKey, String keyPairId, Date dateLessThan) throws InvalidKeySpecException, IOException {
        String resourcePath = CloudFrontUrlSigner.generateResourcePath(protocol, distributionDomain, s3ObjectKey);
        PrivateKey privateKey = CloudFrontUrlSigner.loadPrivateKey(privateKeyFile);
        return CloudFrontUrlSigner.getSignedURLWithCannedPolicy(resourcePath, keyPairId, privateKey, dateLessThan);
    }

    public static String getSignedURLWithCustomPolicy(Protocol protocol, String distributionDomain, File privateKeyFile, String s3ObjectKey, String keyPairId, Date dateLessThan, Date dateGreaterThan, String ipRange) throws InvalidKeySpecException, IOException {
        PrivateKey privateKey = CloudFrontUrlSigner.loadPrivateKey(privateKeyFile);
        String resourcePath = CloudFrontUrlSigner.generateResourcePath(protocol, distributionDomain, s3ObjectKey);
        String policy = CloudFrontUrlSigner.buildCustomPolicyForSignedUrl(resourcePath, dateLessThan, ipRange, dateGreaterThan);
        return CloudFrontUrlSigner.getSignedURLWithCustomPolicy(resourcePath, keyPairId, privateKey, policy);
    }

    public static String getSignedURLWithCustomPolicy(String resourceUrlOrPath, String keyPairId, PrivateKey privateKey, String policy) {
        try {
            byte[] signatureBytes = CloudFrontUrlSigner.signWithSha1RSA(policy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafePolicy = CloudFrontUrlSigner.makeStringUrlSafe(policy);
            String urlSafeSignature = CloudFrontUrlSigner.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Coudln't sign url", (Throwable)e);
        }
    }

    public static String getSignedURLWithCannedPolicy(String resourceUrlOrPath, String keyPairId, PrivateKey privateKey, Date dateLessThan) {
        try {
            String cannedPolicy = CloudFrontUrlSigner.buildCannedPolicy(resourceUrlOrPath, dateLessThan);
            byte[] signatureBytes = CloudFrontUrlSigner.signWithSha1RSA(cannedPolicy.getBytes(StringUtils.UTF8), privateKey);
            String urlSafeSignature = CloudFrontUrlSigner.makeBytesUrlSafe(signatureBytes);
            String signedUrl = resourceUrlOrPath + (resourceUrlOrPath.indexOf(63) >= 0 ? "&" : "?") + "Expires=" + TimeUnit.MILLISECONDS.toSeconds(dateLessThan.getTime()) + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + keyPairId;
            return signedUrl;
        }
        catch (InvalidKeyException e) {
            throw new AmazonClientException("Couldn't sign url", (Throwable)e);
        }
    }

    public static String buildCustomPolicyForSignedUrl(String resourcePath, Date epochDateLessThan, String limitToIpAddressCIDR, Date epochDateGreaterThan) {
        if (epochDateLessThan == null) {
            throw new AmazonClientException("epochDateLessThan must be provided to sign CloudFront URLs");
        }
        if (resourcePath == null) {
            resourcePath = "*";
        }
        String ipAddress = limitToIpAddressCIDR == null ? "0.0.0.0/0" : limitToIpAddressCIDR;
        return CloudFrontUrlSigner.buildCustomPolicy(resourcePath, epochDateLessThan, epochDateGreaterThan, ipAddress);
    }

    static String buildCustomPolicy(String resourcePath, Date epochDateLessThan, Date epochDateGreaterThan, String ipAddress) {
        return "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\"" + ",\"Condition\":{" + "\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(epochDateLessThan.getTime()) + "}" + ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}" + (epochDateGreaterThan == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(epochDateGreaterThan.getTime()) + "}") + "}}]}";
    }

    static String buildCannedPolicy(String resourceUrlOrPath, Date dateLessThan) {
        return "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(dateLessThan.getTime()) + "}}}]}";
    }

    static String makeBytesUrlSafe(byte[] bytes) {
        byte[] encoded = Base64.encode((byte[])bytes);
        block5: for (int i = 0; i < encoded.length; ++i) {
            switch (encoded[i]) {
                case 43: {
                    encoded[i] = 45;
                    continue block5;
                }
                case 61: {
                    encoded[i] = 95;
                    continue block5;
                }
                case 47: {
                    encoded[i] = 126;
                    continue block5;
                }
            }
        }
        return new String(encoded, StringUtils.UTF8);
    }

    private static String makeStringUrlSafe(String str) {
        return CloudFrontUrlSigner.makeBytesUrlSafe(str.getBytes(StringUtils.UTF8));
    }

    private static String generateResourcePath(Protocol protocol, String distributionDomain, String s3ObjectKey) {
        return protocol == Protocol.http || protocol == Protocol.https ? (Object)((Object)protocol) + "://" + distributionDomain + "/" + s3ObjectKey : s3ObjectKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PrivateKey loadPrivateKey(File privateKeyFile) throws InvalidKeySpecException, IOException {
        if (privateKeyFile.getAbsolutePath().toLowerCase().endsWith(".pem")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = PEM.readPrivateKey(is);
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ignore) {}
            }
        }
        if (privateKeyFile.getAbsolutePath().toLowerCase().endsWith(".der")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = RSA.privateKeyFromPKCS8(IOUtils.toByteArray((InputStream)is));
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new AmazonClientException("Unsupported file type for private key");
    }

    private static byte[] signWithSha1RSA(byte[] dataToSign, PrivateKey privateKey) throws InvalidKeyException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey, srand);
            signature.update(dataToSign);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Protocol {
        http,
        https,
        rtmp;

    }
}

