/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResourceDefinition
implements Serializable,
Cloneable {
    private String resourceType;
    private String logicalResourceId;
    private Map<String, String> resourceIdentifier;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceDefinition withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setLogicalResourceId(String logicalResourceId) {
        this.logicalResourceId = logicalResourceId;
    }

    public String getLogicalResourceId() {
        return this.logicalResourceId;
    }

    public ResourceDefinition withLogicalResourceId(String logicalResourceId) {
        this.setLogicalResourceId(logicalResourceId);
        return this;
    }

    public Map<String, String> getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public ResourceDefinition withResourceIdentifier(Map<String, String> resourceIdentifier) {
        this.setResourceIdentifier(resourceIdentifier);
        return this;
    }

    public ResourceDefinition addResourceIdentifierEntry(String key, String value) {
        if (null == this.resourceIdentifier) {
            this.resourceIdentifier = new HashMap<String, String>();
        }
        if (this.resourceIdentifier.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.resourceIdentifier.put(key, value);
        return this;
    }

    public ResourceDefinition clearResourceIdentifierEntries() {
        this.resourceIdentifier = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getLogicalResourceId() != null) {
            sb.append("LogicalResourceId: ").append(this.getLogicalResourceId()).append(",");
        }
        if (this.getResourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.getResourceIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDefinition)) {
            return false;
        }
        ResourceDefinition other = (ResourceDefinition)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getLogicalResourceId() == null ^ this.getLogicalResourceId() == null) {
            return false;
        }
        if (other.getLogicalResourceId() != null && !other.getLogicalResourceId().equals(this.getLogicalResourceId())) {
            return false;
        }
        if (other.getResourceIdentifier() == null ^ this.getResourceIdentifier() == null) {
            return false;
        }
        return other.getResourceIdentifier() == null || other.getResourceIdentifier().equals(this.getResourceIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getLogicalResourceId() == null ? 0 : this.getLogicalResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIdentifier() == null ? 0 : this.getResourceIdentifier().hashCode());
        return hashCode;
    }

    public ResourceDefinition clone() {
        try {
            return (ResourceDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

