/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.ModuleInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ModuleInfoStaxUnmarshaller
implements Unmarshaller<ModuleInfo, StaxUnmarshallerContext> {
    private static ModuleInfoStaxUnmarshaller instance;

    public ModuleInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        ModuleInfo moduleInfo = new ModuleInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return moduleInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TypeHierarchy", targetDepth)) {
                    moduleInfo.setTypeHierarchy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LogicalIdHierarchy", targetDepth)) continue;
                moduleInfo.setLogicalIdHierarchy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return moduleInfo;
    }

    public static ModuleInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ModuleInfoStaxUnmarshaller();
        }
        return instance;
    }
}

