/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.PublishTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PublishTypeRequestMarshaller
implements Marshaller<Request<PublishTypeRequest>, PublishTypeRequest> {
    public Request<PublishTypeRequest> marshall(PublishTypeRequest publishTypeRequest) {
        if (publishTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishTypeRequest, "AmazonCloudFormation");
        request.addParameter("Action", "PublishType");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishTypeRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)publishTypeRequest.getType()));
        }
        if (publishTypeRequest.getArn() != null) {
            request.addParameter("Arn", StringUtils.fromString((String)publishTypeRequest.getArn()));
        }
        if (publishTypeRequest.getTypeName() != null) {
            request.addParameter("TypeName", StringUtils.fromString((String)publishTypeRequest.getTypeName()));
        }
        if (publishTypeRequest.getPublicVersionNumber() != null) {
            request.addParameter("PublicVersionNumber", StringUtils.fromString((String)publishTypeRequest.getPublicVersionNumber()));
        }
        return request;
    }
}

