/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.AutoDeployment;
import com.amazonaws.services.cloudformation.model.CreateStackSetRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateStackSetRequestMarshaller
implements Marshaller<Request<CreateStackSetRequest>, CreateStackSetRequest> {
    public Request<CreateStackSetRequest> marshall(CreateStackSetRequest createStackSetRequest) {
        AutoDeployment autoDeployment;
        if (createStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackSetRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)createStackSetRequest.getStackSetName()));
        }
        if (createStackSetRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createStackSetRequest.getDescription()));
        }
        if (createStackSetRequest.getTemplateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackSetRequest.getTemplateBody()));
        }
        if (createStackSetRequest.getTemplateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackSetRequest.getTemplateURL()));
        }
        if (createStackSetRequest.getParameters().isEmpty() && !((SdkInternalList)createStackSetRequest.getParameters()).isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!createStackSetRequest.getParameters().isEmpty() || !((SdkInternalList)createStackSetRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)createStackSetRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue != null) {
                    if (parametersListValue.getParameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.getParameterKey()));
                    }
                    if (parametersListValue.getParameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                    }
                    if (parametersListValue.getUsePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.getUsePreviousValue()));
                    }
                    if (parametersListValue.getResolvedValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringUtils.fromString((String)parametersListValue.getResolvedValue()));
                    }
                }
                ++parametersListIndex;
            }
        }
        if (createStackSetRequest.getCapabilities().isEmpty() && !((SdkInternalList)createStackSetRequest.getCapabilities()).isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!createStackSetRequest.getCapabilities().isEmpty() || !((SdkInternalList)createStackSetRequest.getCapabilities()).isAutoConstruct()) {
            SdkInternalList capabilitiesList = (SdkInternalList)createStackSetRequest.getCapabilities();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (createStackSetRequest.getTags().isEmpty() && !((SdkInternalList)createStackSetRequest.getTags()).isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!createStackSetRequest.getTags().isEmpty() || !((SdkInternalList)createStackSetRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createStackSetRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (createStackSetRequest.getAdministrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN", StringUtils.fromString((String)createStackSetRequest.getAdministrationRoleARN()));
        }
        if (createStackSetRequest.getExecutionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringUtils.fromString((String)createStackSetRequest.getExecutionRoleName()));
        }
        if (createStackSetRequest.getPermissionModel() != null) {
            request.addParameter("PermissionModel", StringUtils.fromString((String)createStackSetRequest.getPermissionModel()));
        }
        if ((autoDeployment = createStackSetRequest.getAutoDeployment()) != null) {
            if (autoDeployment.getEnabled() != null) {
                request.addParameter("AutoDeployment.Enabled", StringUtils.fromBoolean((Boolean)autoDeployment.getEnabled()));
            }
            if (autoDeployment.getRetainStacksOnAccountRemoval() != null) {
                request.addParameter("AutoDeployment.RetainStacksOnAccountRemoval", StringUtils.fromBoolean((Boolean)autoDeployment.getRetainStacksOnAccountRemoval()));
            }
        }
        request.addParameter("ClientRequestToken", IdempotentUtils.resolveString((String)createStackSetRequest.getClientRequestToken()));
        return request;
    }
}

